# Upstream joined two projects, fbi and ida (framebuffer and Motif-based image
# viewers) into united project named "fbida". But we really not interested in
# packaging ugly motif apps, so we will name our main package just "fbi".

%def_enable snapshot

Name: fbi
Version: 2.14
Release: alt3

Summary: Image viewer for Linux framebuffer console
License: GPL-2.0-or-later
Group: Graphics
Url: https://www.kraxel.org/cgit/fbida/
Vcs: https://github.com/kraxel/fbida

%if_disabled snapshot
Source: http://www.kraxel.org/releases/fbida/fbida-%version.tar.gz
%else
Source: fbida-%version.tar
%endif
# according to changes in libxkbcommon-1.6
Patch10: fbida-2.14-alt-libxkbcommon-1.6.patch
Patch11: fbida-2.14-alt-tsm-draw-cb.patch

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
# image format BR
BuildRequires: libjpeg-devel
BuildRequires: libpcd-devel
BuildRequires: pkgconfig(libexif)
BuildRequires: pkgconfig(libpng)
BuildRequires: pkgconfig(libtiff-4)
BuildRequires: pkgconfig(libwebp)
BuildRequires: pkgconfig(pixman-1)
# fbi & fbpdf BR
BuildRequires: pkgconfig(freetype2)
BuildRequires: pkgconfig(fontconfig)
BuildRequires: pkgconfig(libdrm)
BuildRequires: pkgconfig(poppler-glib)
BuildRequires: pkgconfig(gbm)
BuildRequires: pkgconfig(egl)
BuildRequires: pkgconfig(epoxy)
BuildRequires: pkgconfig(cairo)
BuildRequires: pkgconfig(libudev)
BuildRequires: pkgconfig(libinput)
BuildRequires: pkgconfig(xkbcommon)
# fbcon BR
BuildRequires: pkgconfig(libtsm)
BuildRequires: pkgconfig(systemd)

%description
Image viewer for Linux framebuffer console.

%package -n fbpdf
Summary: Framebuffer PDF viewer
Group: Graphics

%description -n fbpdf
PDF viewer for Linux framebuffer console.

%package -n exiftran
Summary: Command line tool to do lossless transformations of JPEG images
Group: Graphics

%description -n exiftran
Command line tool to do lossless transformations of JPEG images, similar to
jpegtran but includes EXIF data.

%package -n fbcon
Summary: Framebuffer terminal console
Group: Graphics

%description -n fbcon
Framebuffer terminal console.

%prep
%setup -n fbida-%version
%patch10
%patch11

echo %version > VERSION

%build
%meson
%meson_build

%install
%meson_install

%files
%_bindir/fbi
%_man1dir/fbi.1*

%files -n fbpdf
%_bindir/fbpdf

%files -n exiftran
%_bindir/exiftran
%_man1dir/exiftran*

%files -n fbcon
%_bindir/fbcon
%_datadir/wayland-sessions/fbcon.desktop

%changelog
