%define rname extra-cmake-modules

%def_enable doc
%def_disable clang

%ifarch %e2k
%def_disable clang
%else
%def_disable clang
%endif

%if_disabled clang
%add_python3_req_skip clang
%add_python3_req_skip clang.cindex
%endif
%add_python3_req_skip PyQt6.Qt
%add_python3_req_skip PyQt5.Qt

AutoReq: yes, nopython
AutoProv: yes, nopython nopython3
%add_python3_path %_datadir/ECM/find-modules

Name: extra-cmake-modules
Version: 6.19.0
Release: alt2

Group: Development/Other
Summary: Additional modules for CMake build system
License: BSD
Url: http://community.kde.org/KDE_Core/Platform_11/Buildsystem/FindFilesSurvey

# unable to remove noarch for e2k
BuildArch: noarch

Requires: cmake
%if_enabled clang
Requires: clang-devel
%endif

Source: %name-%version.tar
Patch1: alt-hide-about-reusetool.patch
Patch2: alt-old-cmake.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: cmake qt6-tools qt6-tools-devel
%if_enabled doc
BuildRequires: python3-module-sphinx-sphinx-build-symlink
%endif


%description
Additional modules for CMake build system needed by KDE Frameworks.

%prep
%setup
%patch1 -p1
%patch2 -p1

# can't do %%ifarch here becouse noarch build
if [ "$(arch)" = "e2k" ]; then
	# kf6-kcoreaddons linking warning gets fatal otherwise (mcst#3675)
	sed -i 's|-Wl,--fatal-warnings|-Wl,--no-warn-shared-textrel|' \
		kde-modules/KDECompilerSettings.cmake
	# kf6-ki18n ftbfs with -Werror=missing-return (mcst#7001)
	sed -i 's|-Werror|-Wno-error|g' \
		kde-modules/KDECompilerSettings.cmake
fi

%build
%cmake \
    -DBUILD_TESTING:BOOL=FALSE \
    #
#    -DBUILD_QTHELP_DOCS:BOOL=TRUE \
%cmake_build

%install
%cmakeinstall_std

%files
%_datadir/ECM
%doc README.rst LICENSES/* README.md
%if_enabled doc
%doc %_docdir/ECM
%doc %_man7dir/*
%endif

%changelog
