# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++ python3-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name evemu
%define		major		3
%define		libname		lib%{name}%{major}
%define		devname		lib%{name}-devel

Name:		evemu
Version:	2.7.0
Release:	alt2_9
Summary:	Event Device Query and Emulation Program
Group:		Development/Other
License:	GPLv3+
URL:		https://www.freedesktop.org/wiki/Evemu/
Source0:	https://www.freedesktop.org/software/%{name}/%{name}-%{version}.tar.xz

BuildRequires:	automake
BuildRequires:	libtool
BuildRequires:	pkgconfig(python3)
BuildRequires:	pkgconfig(libevdev) >= 0.5
BuildRequires:	xmlto
BuildRequires:	asciidoc asciidoc-a2x
Source44: import.info

%description
%{name} is a simple utility to capture the event stream from input devices
and replay that stream on a virtual input device.

#------------------------------------------------------------------

%package -n	%{libname}
Summary:	Event Device Query and Emulation Program Library Package
Group:		System/Libraries
Requires:	%{name} = %{version}-%{release}

%description -n	%{libname}
This package contains the library needed to run programs
dynamically linked with evemu.

#------------------------------------------------------------------

%package -n	%{devname}
Summary:	Event Device Query and Emulation Program Development Package
Group:		Development/Other
Requires:       %{libname} = %{version}-%{release}
Requires:	python3 python3-tools
Provides:	%{name}-devel = %{version}-%{release}
Provides:	lib%{name}-devel = %{version}-%{release}

%description -n	%{devname}
This package provides headers files for evemu development.

#------------------------------------------------------------------
%prep
%setup -q

%build
export PYTHON=%{__python3}
autoreconf -vfi
%configure \
		--disable-static
%make_build

%install
%makeinstall_std

# we don't want these
find %{buildroot} -name '*.la' -delete

%files
%doc COPYING
%{_bindir}/%{name}-describe
%{_bindir}/%{name}-device
%{_bindir}/%{name}-play
%{_bindir}/%{name}-record
%{_bindir}/%{name}-event
%{_mandir}/man1/%{name}-*.1*

%files -n %{libname}
%{_libdir}/lib%{name}.so.%{major}
%{_libdir}/lib%{name}.so.%{major}.*

%files -n %{devname}
%{_includedir}/%{name}.h
%{_libdir}/lib%{name}.so
%{_libdir}/pkgconfig/%{name}.pc
%dir %{python3_sitelibdir_noarch}/%{name}/
%{python3_sitelibdir_noarch}/%{name}/*


%changelog
