%global import_path github.com/etcd-io/etcd

%global _unpackaged_files_terminate_build 1

%define git_commit   f20bbad

Name:    etcd-for-kubernetes1.29
Version: 3.5.16
Release: alt3
Summary: A highly-available key value store for shared configuration
License: Apache-2.0
Group:   System/Servers

URL:     https://etcd.io
VCS:     https://github.com/etcd-io/etcd

Source0: %name-%version.tar

Provides: etcd-for-kubernetes = %EVR
Conflicts: etcd-for-kubernetes
Conflicts: etcd

ExclusiveArch: %go_arches
BuildRequires(pre): rpm-macros-golang
BuildRequires: rpm-build-golang golang >= 1.22

%description
Etcd is a distributed key value store that provides a reliable way to store data
across a cluster of machines.
This package contains etcd version needed for kubernetes container image.

%prep
%setup -q

%build
export CGO_ENABLED=0
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export LDFLAGS="-X go.etcd.io/etcd/api/v3/version.GitSHA=%git_commit"

%golang_prepare

cd .build/src/%import_path

%golang_build \
    server \
    etcdctl \
#

%install
export BUILDDIR="$PWD/.build"

%golang_install

mkdir -p -- %buildroot%_sbindir

mv -f -- %buildroot%_bindir/server %buildroot%_sbindir/etcd

# remove unused files
rm -rf -- %buildroot/%go_root

%files
%_bindir/etcdctl
%_sbindir/etcd

%changelog
