%def_disable snapshot

%define _name Errands
%define ver_major 46
%define rdn_name io.github.mrvladus.List

%def_enable check

Name: errands
Version: %ver_major.2.9
Release: alt1

Summary: Todo application for GNOME
License: MIT
Group: Office
Url: https://github.com/mrvladus/Errands

Vcs: https://github.com/mrvladus/Errands.git

%if_disabled snapshot
Source: %url/archive/%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

%define adwaita_ver 1.5

Requires: typelib(Adw) = 1 typelib(GtkSource) = 5
Requires: yelp

BuildArch: noarch

%add_python3_path %_datadir/%name

Requires: python3-module-pygobject3
Requires: python3-module-icalendar >= 5.0.11
Requires: dconf gnome-keyring gnome-online-accounts

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-gir
BuildRequires: meson yelp-tools
BuildRequires: pkgconfig(libadwaita-1)
BuildRequires: pkgconfig(gtksourceview-5)
BuildRequires: pkgconfig(pygobject-3.0)
BuildRequires: pkgconfig(libsecret-1)
BuildRequires: pkgconfig(goa-1.0)
BuildRequires: pkgconfig(libportal)
%{?_enable_check:BuildRequires: python3(pytest) desktop-file-utils /usr/bin/appstreamcli}

%description
Todo application for those who prefer simplicity.

%prep
%setup %{?_disable_snapshot:-n %_name-%version}

%build
%meson
#%meson_build %name-pot %name-update-po
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name

%check
%__meson_test

%files -f %name.lang
%attr(0755,root,root) %_bindir/%name
%_datadir/%name/
%_desktopdir/%rdn_name.desktop
%_datadir/dbus-1/services/%rdn_name.service
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_iconsdir/hicolor/*/apps/*.svg
%_datadir/metainfo/%rdn_name.metainfo.xml
%doc README*

%changelog
