%define _name eog
%define ver_major 44
%define beta %nil
%define api_ver 3.0
%def_enable map
%def_disable postr
%def_enable postasa

Name: %_name-plugins
Version: %ver_major.1
Release: alt1%beta

Summary: EOG plugins
License: %gpl2plus
Group: Graphics
Url: https://wiki.gnome.org/Apps/EyeOfGnome
Source: %gnome_ftp/%name/%ver_major/%name-%version%beta.tar.xz

Requires: eog >= %ver_major libpeas-python3-loader

%add_python3_path %_libdir/%_name/plugins
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
Requires: libpeas-python3-loader

%define libchamplain_ver 0.12
%define gdata_ver 0.6.0
%define peas_ver 1.14.1

BuildRequires(pre): rpm-macros-meson rpm-build-licenses rpm-build-gnome rpm-build-gir
BuildRequires: meson eog-devel >= %ver_major %_bindir/appstream-util
BuildRequires: libpeas-devel >= %peas_ver libgnome-desktop3-devel
%{?_enable_map:BuildRequires: libchamplain-gtk3-devel >= %libchamplain_ver}
%{?_enable_postasa:BuildRequires: libgdata-devel >= %gdata_ver}
BuildRequires: libexempi-devel zlib-devel libjpeg-devel
BuildRequires: libdbus-glib-devel libxml2-devel librsvg-devel libexif-devel
BuildRequires: gsettings-desktop-schemas-devel gnome-icon-theme

%description
This package provides plugins for the Eye of GNOME, an image viewer program.

%package -n %_name-plugins-postr
Summary: Flickr uploader for EOG
Group: Graphics
Requires: %name = %version-%release
Requires: postr

%description -n %_name-plugins-postr
This package provides Eog plugin for upload pictures to Flickr.

%package -n %_name-plugins-postasa
Summary: Picasa uploader for EOG
Group: Graphics
Requires: %name = %version-%release

%description -n %_name-plugins-postasa
This package provides Eog plugin for upload pictures to Picasa web albums.

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_libdir/%_name/plugins/*
%_datadir/%_name/plugins/*
%_datadir/metainfo/%_name-*.appdata.xml
%if_enabled postasa
%exclude %_libdir/%_name/plugins/postasa.plugin
%exclude %_libdir/%_name/plugins/libpostasa.so
%exclude %_datadir/metainfo/%_name-postasa.appdata.xml
%endif
%if_enabled postr
%exclude %_libdir/%_name/plugins/postr.plugin
%exclude %_libdir/%_name/plugins/libpostr.so
%exclude %_datadir/metainfo/%_name-postr.appdata.xml
%endif
%config %_datadir/glib-2.0/schemas/org.gnome.%_name.plugins.exif-display.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.%_name.plugins.fullscreenbg.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.%_name.plugins.pythonconsole.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.%_name.plugins.export-to-folder.gschema.xml
%doc AUTHORS NEWS README

%if_enabled postr
%files -n %_name-plugins-postr
%_libdir/%_name/plugins/postr.plugin
%_libdir/%_name/plugins/libpostr.so
%_datadir/metainfo/%_name-postr.metainfo.xml
%endif

%if_enabled postasa
%files -n %_name-plugins-postasa
%_libdir/%_name/plugins/postasa.plugin
%_libdir/%_name/plugins/libpostasa.so
%_datadir/metainfo/%_name-postasa.appdata.xml
%endif

%changelog
