%def_without stardict

%define	dict_name engcom
%define dictdesc The Open English-Russian Dictionary of Computer Terms

Name: engcom
Version: 1.40
Release: alt1

Summary: The Open English-Russian Dictionary of Computer Terms
Summary(ru_RU.UTF-8): Свободный англо-русский словарь компьютерных терминов

License: FDL
URL: http://www.etersoft.ru/engcom
Group: Text tools

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: ftp://download.etersoft.ru/pub/Etersoft/Sisyphus/sources/tarball/%name-%version.tar

BuildArchitectures: noarch

BuildRequires: dict-tools makedict stardict-tools

%description
The %name package contains free (as speech) English-Russian
Dictionary of Computer Terms. It is not academic dictionary.

%description -l ru_RU.UTF-8
Пакет %name содержит англо-русский словарь компьютерных
терминов, составленный по мотивам реальной жизни.

%package -n mova-%name

Summary: %dictdesc for mova
Summary(ru_RU.UTF-8): Свободный англо-русский словарь компьютерных терминов для mova
Group: Text tools
Obsoletes: engcom engcom-mova
Provides: engcom engcom-mova
Requires: mova

%description -n mova-%name
The %name package contains free (with FDL license ) English-Russian
Dictionary of Computer Terms in mova format. It is not academic dictionary.

%description -n mova-%name -l ru_RU.UTF-8
Пакет %name содержит свободный англо-русский словарь компьютерных
терминов в формате mova, составленный по мотивам реальной жизни,
содержанию компьютерной прессы и рассылок.

%package -n dict-%name

Summary: %dictdesc for dict dictionary
Summary(ru_RU.UTF-8): Свободный англо-русский словарь компьютерных терминов в формате dict
Group: Text tools
Requires: dictd >= 1.7.1

%description -n dict-%name
The %name package contains free (with FDL license) English-Russian
Computer Dictionary in dict format. It is not academic dictionary.

%description -n dict-%name -l ru_RU.UTF-8
Пакет %name содержит свободный англо-русский словарь компьютерных
терминов в формате словарей dictd, составленный по мотивам реальной жизни,
содержанию компьютерной прессы и рассылок.

%package -n stardict-%name

Summary: The Open English-Russian Dictionary of Computer Terms for stardict dictionary
Summary(ru_RU.UTF-8): Свободный англо-русский словарь компьютерных терминов в формате stardict
Group: Text tools
Requires: stardict

%description -n stardict-%name
The %name package contains free (with FDL license) English-Russian
Computer Dictionary in stardict format. It is not academic dictionary.

%description -n stardict-%name -l ru_RU.UTF-8
Пакет %name содержит свободный англо-русский словарь компьютерных
терминов в формате словарей stardict, составленный по мотивам реальной жизни,
содержанию компьютерной прессы и рассылок.

%prep
%setup

%build
export LANG=C
export TITLE="%dictdesc"
export URL="http://engcom.org.ru"
%__make
mv EngCom.koi %dict_name.koi

# FIXME: mueller only convertor
#makedict -i mueller7 -o xdxf %dict_name.koi %dict_name

# Specially modified makedict convertor
./engcom_parser.py EngCom.source >%dict_name.tmp
grep -v "<meta_info>" %dict_name.tmp >%dict_name

mkdir -p out
# CHECKME: makes broken dict?
makedict -i xdxf -o dictd %dict_name -d out

# BROKEN:
#makedict -i xdxf -o stardict %dict_name -d out

%install
# install mova files
install -p -m644 -D %dict_name.koi %buildroot%_datadir/dict/%dict_name.koi

# install dict files
cd out/%dict_name
dictzip %dict_name.dict
for i in dict.dz index
do
	install -p -m644 -D %dict_name.$i %buildroot%_datadir/dictd/%dict_name.$i
done
cd -

%if_with stardict
# install stardict files
cd out/stardict-%dict_name-2.4.2
cat << EOF >> %dict_name.ifo
author=Vitaly Lipatov
email=lav@etersoft.ru
website=http://etersoft.ru
EOF

gzip %dict_name.idx
dictzip %dict_name.dict
for i in dict.dz idx.gz ifo
do
	install -p -m644 -D %dict_name.$i %buildroot%_datadir/stardict/dic/%dict_name.$i
done
cd -
%endif

%post -n dict-%name
%_sbindir/dictdconfig -w

%postun -n dict-%name
%_sbindir/dictdconfig -w

%files -n mova-%name
%doc docs
%_datadir/dict/*.koi

%files -n dict-%name
%doc docs
%_datadir/dictd/*

%if_with stardict
%files -n stardict-%name
%doc docs
%_datadir/stardict/dic/*
%endif

%changelog
