Name: emelfm2
Version: 0.9.1
Release: alt1

Summary: file manager for UNIX-like operating systems
License: GPLv3+
Group: File tools

Url: http://emelfm2.net
Source: %name-%version.tar

BuildRequires: libgimp-devel libacl-devel libgtk+2-devel libgtkspell-devel libudisks2-devel libdbus-glib-devel libmagic-devel
BuildRequires:  desktop-file-utils
BuildRequires:  gettext
BuildRequires:  libudisks2-devel

%description
emelFM2 is a file manager for UNIX-like operating systems. It uses
a simple and efficient interface pioneered by Norton Commander in the
1980s. The main window is divided into three parts, described as "panes"
or "panels". Two of those (side-by-side or top-to-bottom) show the
contents of selected filesystem directories. The third pane at the
bottom of the window shows the output of commands executed within the
program. Those panes can be resized, and any one or two of them can
be hidden and unhidden, on request. A built-in command-line, toolbar
buttons or assigned keys can be used to initiate commands.

%prep
%setup
# lcc 1.29/e2k fixup (remove when updating to 0.9.1)
#sed -i 's/GTK_STOCK_DISCARD "/"gtk-discard" "/' src/e2_main.c

%build
%add_optflags -fcommon
%make_build \
     PREFIX=%_prefix LIB_DIR=%_libdir    CFLAGS="%optflags" STRIP=0 \
     DOCS_VERSION=1  WITH_TRANSPARENCY=1 WITH_KERNELFAM=1 EDITOR_SPELLCHECK=1 \
     NEW_COMMAND=1   WITH_DEVKIT=1       WITH_THUMBS=1    WITH_TRACKER=1 \
     XDG_APPLICATION_DIR=%{_datadir}/application-registry \
     WITH_ACL=1      WITH_POLKIT=1

%install
make install install_i18n \
             DOCS_VERSION=1 \
             PREFIX=%buildroot%_prefix \
             PLUGINS_DIR=%buildroot%_libdir/%name/plugins
for size in 24 32 48; do
    mkdir -p %buildroot%_iconsdir/hicolor/${size}x$size/apps
    cp  %buildroot%_pixmapsdir/%name/%{name}_$size.png \
        %buildroot%_iconsdir/hicolor/${size}x$size/apps/%name.png
done

%find_lang %name

%files -f %name.lang
%_bindir/%name
%_desktopdir/%name.desktop
#_datadir/application-registry/%name.applications
%_libdir/%name
%_man1dir/%name.1*
%_pixmapsdir/%name
%_iconsdir/hicolor/24x24/apps/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png
%_datadir/doc/%name-%version

# TODO: update to 0.9.1 after review; cf. ALT#54033
# (trac instance at emelfm2.net looks compromised
# as of 2024-04-28 with shady links added there)

%changelog
