%def_without texmf
%define ModeName auctex

Name: emacs-mode-%ModeName
Version: 13.3
Release: alt2.2

Summary: Enhanced LaTeX mode for GNU Emacs
License: GPLv3
Group: Editors
Url: http://www.gnu.org/software/auctex/index.html
Packager: Emacs Maintainers Team <emacs@packages.altlinux.org>
BuildArch: noarch

#Source0: ftp://sunsite.auc.dk/packages/auctex/%ModeName-%version.tar.bz2
Source0: ftp://ftp.gnu.org/pub/gnu/auctex/%ModeName-%version.tar.gz

# Due to patches 1 and 2, the administrator of a system won't have to set
# any site-specific variables for AUC TeX.

Requires: common-licenses
%if_with texmf
Requires: texmf-latex-preview
%else
Requires: tex(preview.sty)
%endif

Provides: preview-latex
Provides: emacs-preview-latex = %version-%release
Obsoletes: emacs-preview-latex < 11.82
Obsoletes: auctex

Requires: gnu-ghostscript /usr/bin/dvips /usr/bin/latex

BuildRequires(pre): rpm-build-tex
BuildRequires: texlive-dist
BuildRequires: /usr/bin/emacs /usr/bin/dvips /usr/bin/latex

%description
AUC TeX is a comprehensive, customizable, integrated environment for
writing, editing and processing input files for LaTeX using GNU Emacs.
This mode also supports graphic preview for formulas and figures.

(Emacs Lisp code is principally byte-compiled, install %name-el for sources.)

%package el
Summary: The Emacs Lisp sources for bytecode included in %name
Group: Development/Other

Requires: %name = %version-%release
Provides: emacs-preview-latex-el = %version-%release

%description el
%name-el contains the Emacs Lisp sources for the bytecode included in the %name package,
that extends the Emacs editor.

You need to install %name-el only if you intend to modify any of the
%name code or see some Lisp examples.

#FIXME: fix install to texlive
%package doc
Summary: 	Documentation for %name
Group: 		Editors

Requires: emacs-mode-auctex 
Requires: /usr/share/texmf/doc

%description -n emacs-mode-auctex-doc
Does your neck hurt from turning between previewer windows and the
source too often? This Elisp/LaTeX package will render your displayed
LaTeX equations right into the editing window where they belong. 

This package contains the documentation.

%package -n texmf-latex-preview
Summary: Preview style for TeX subsystems.
Group: Development/Other
BuildArch: noarch

%description -n texmf-latex-preview
%name-el contains the Emacs Lisp sources for the bytecode included in the %name package,
that extends the Emacs editor.

You need to install %name-el only if you intend to modify any of the
%name code or see some Lisp examples.

%prep
%setup -q -n %ModeName-%version

%build
%configure --with-tex-input-dirs=/usr/share/texmf/tex \
           --with-auctexstartfile=%_datadir/emacs/site-lisp/auctex.el \
           --with-previewstartfile=%_datadir/emacs/site-lisp/preview-latex.el
%make_build 

%install
%makeinstall_std

ln -s -f %_licensedir/GPL-2 COPYING
rm -f %buildroot%_infodir/dir

# Create these .nosearch files to keep the directories from the elisp search path
touch %buildroot%_emacslispdir/auctex/style/.nosearch

%global _customdocdir %_defaultdocdir/auctex

%files
%_infodir/*
%_emacslispdir/*.el
%_emacslispdir/auctex
%_datadir/texmf/tex/latex/preview
%exclude %_texmfmain/tex/latex/preview/preview.sty
%exclude %_emacslispdir/auctex/*.el
%exclude %_emacslispdir/auctex/style/*.el
%_emacslispdir/auctex/style/.nosearch

%files el 
%_emacslispdir/auctex/*.el
%_emacslispdir/auctex/style/*.el

%files -n %name-doc
%_datadir/texmf/doc/latex/styles/*
%_datadir/doc/auctex
%doc --no-dereference COPYING
%doc ChangeLog*

%if_with texmf
%files -n texmf-latex-preview
%_texmfmain/tex/latex/preview/preview.sty
%endif

%changelog
