Name: emacs
Version: 30.2
Release: alt1

Summary: GNU Emacs text editor
License: GPLv3+
Group: Editors
Url: http://www.gnu.org/software/emacs/

Source: %name-%version-%release.tar

%ifarch %e2k
%def_disable natcomp
%else
%def_enable natcomp
%endif

BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(cairo)
BuildRequires: pkgconfig(dbus-1)
BuildRequires: pkgconfig(fontconfig)
BuildRequires: pkgconfig(freetype2)
BuildRequires: pkgconfig(gio-2.0)
BuildRequires: pkgconfig(glib-2.0)
BuildRequires: pkgconfig(gmp)
BuildRequires: pkgconfig(gnutls)
BuildRequires: pkgconfig(gobject-2.0)
BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(harfbuzz)
BuildRequires: pkgconfig(lcms2)
BuildRequires: pkgconfig(libacl)
BuildRequires: pkgconfig(libjpeg)
BuildRequires: pkgconfig(libpng)
BuildRequires: pkgconfig(librsvg-2.0)
BuildRequires: pkgconfig(libselinux)
BuildRequires: pkgconfig(libsystemd)
BuildRequires: pkgconfig(libtiff-4)
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(sqlite3)
BuildRequires: pkgconfig(tinfo)
BuildRequires: pkgconfig(tree-sitter)
BuildRequires: pkgconfig(xaw3d)
BuildRequires: pkgconfig(xfixes)
BuildRequires: pkgconfig(xft)
BuildRequires: pkgconfig(xinerama)
BuildRequires: pkgconfig(xpm)
BuildRequires: pkgconfig(xrandr)
BuildRequires: pkgconfig(zlib)

BuildRequires(pre): rpm-macros-alternatives
BuildRequires: texinfo
BuildRequires: libgif-devel
%{?_enable_natcomp:BuildRequires: libgccjit-devel}

%package athena
Summary: The GNU Emacs text editor for the X Window System (athena)
Group: Editors
Requires(pre): alternatives >= 0.2.0
Requires: emacs-common = %version-%release
Provides: /usr/bin/emacs
Provides: emacs = %version-%release
Provides: emacs-X11 = %version-%release
Provides: emacs-nox = %version-%release
Obsoletes: emacs-nox

%package gtk3
Summary: The GNU Emacs text editor for the X Window System (gtk3)
Group: Editors
Requires(pre): alternatives >= 0.2.0
Requires: emacs-common = %version-%release
Provides: /usr/bin/emacs
Provides: emacs = %version-%release
Provides: emacs-X11 = %version-%release

%package pgtk
Summary: The GNU Emacs text editor for alternative windowing systems.
Group: Editors
Requires(pre): alternatives >= 0.2.0
Requires: emacs-common = %version-%release
Provides: /usr/bin/emacs
Provides: emacs = %version-%release

%package common
Summary: Things needed to run the GNU Emacs text editor
Group: Editors
%{?_enable_natcomp:Requires: %name-el = %version-%release}
Provides: %_libexecdir/emacs
Provides: emacs-cedet = %version-%release
Provides: emacs-gnus = %version-%release
Provides: emacs-speedbar = %version-%release
Conflicts: app-defaults < 0.2.1-alt1
Conflicts: emacs-base-X11 < 0.0.2
Obsoletes: emacs-base-X11 < 0.0.2
AutoReq: yes, nopython

%package el
Summary: The sources for Lisp programs included with GNU Emacs
Group: Development/Other
BuildArch: noarch
Requires: %name-common = %version-%release

%package leim
Summary: GNU Emacs Lisp code for input methods for internationalization
Group: Editors
BuildArch: noarch
Requires: %name-common = %version-%release

%package leim-el
Summary: The Emacs Lisp source code for input methods included in %name-leim
Group: Development/Other
BuildArch: noarch
Requires: %name-leim = %version-%release

%package info
Summary: Info docs for GNU Emacs text editor
Group: Editors
BuildArch: noarch
Requires: %name-common = %version-%release

%package elisp-manual
Summary: Emacs Lisp Manual
Group: Editors
BuildArch: noarch
Requires: %name-common = %version-%release

#{{{
%define desc \
Emacs is an extensible, customizable, self-documenting real-time\
display editor.  Emacs contains special code editing features, an\
extension language (Emacs Lisp), and the capability to read mail, news\
and more without leaving the editor.

%description %desc

%description athena %desc
emacs-athena includes the GNU Emacs text editor program for use with the X
Window System using athena widget set (it provides support for the mouse and
other GUI elements).  It will also run GNU Emacs outside of X.

%description gtk3 %desc
emacs-gtk3 includes the GNU Emacs text editor program for use with the X
Window System using gtk+ toolkit v.3 (it provides support for the mouse and
other GUI elements).  It will also run GNU Emacs outside of X.

%description pgtk %desc
emacs-pgtk is the GNU Emacs text editor program for use primarily
with Wayland windowing system.
If you use exclusively X, do not use this package. There are a
number of respects in which the regular gtk3 variant works better.

%description common %desc
This package includes things you need to run the Emacs editor, so you
need to install this package if you intend to use Emacs.  You also
need to install the actual Emacs program package (emacs-athena,
emacs-gtk3 or emacs-pgtk).

%description el
Emacs-el contains the Emacs Lisp sources for many of the programs
included with the main GNU Emacs text editor package.

You need to install %name-el only if you intend to modify any of the
Emacs packages or see some Lisp examples.

If you need the sources for %name-leim, install %name-leim-el.

%description leim
The Lisp code for input methods for various international scripts for GNU Emacs.

%description leim-el
Emacs-leim-el contains the Emacs Lisp sources for the Emacs Lisp code
for input methods for various international scripts of GNU Emacs.

You need to install %name-leim-el only if you intend to modify any of theses
GNU Emacs packages, see some Lisp examples or for reference for configuring your
localized input methods.

%description info
This package contain full GNU Emacs documentation in Info format except
Emacs Lisp language documentation that contains in %name-elisp-manual
package

%description elisp-manual
This package contain full description of Emacs Lisp language
#}}}

%define _emacs_archlibdir %_libexecdir/emacs/%version/%_host_alias
%define locallisppath %_datadir/emacs/site-lisp:%_datadir/emacs/%version/site-lisp:%_libdir/emacs/%version/site-lisp
%ifarch %e2k
# on default -O3 crashes with SIGILL in lucid_event_type_list_p
%global _optlevel 2
%endif

%prep
%setup
sed -ri 's,(\.\./info/[[:alpha:]-]+),\1.info,g' doc/{emacs,misc}/*.texi

%build
autoreconf -i -I m4

%define _configure_script ../configure
%define _configure_mostly --disable-build-details --sharedstatedir=/var \\\
	--without-pop --without-gpm --with-wide-int --with-modules \\\
	--enable-locallisppath=%locallisppath \\\
	%{?_enable_natcomp:--with-native-compilation=aot}

mkdir build-athena && pushd build-athena
%configure %_configure_mostly --without-cairo --without-rsvg \
	--without-dbus --without-gconf --without-gsettings \
	--with-x-toolkit=athena
%make_build
popd

mkdir build-gtk3 && pushd build-gtk3
%configure %_configure_mostly --with-x-toolkit=gtk3
make bootstrap
%make_build
popd

mkdir build-pgtk && pushd build-pgtk
%configure %_configure_mostly --with-pgtk
make bootstrap
%make_build
popd

%install
%makeinstall -C build-pgtk

install -pm0755 build-athena/src/emacs %buildroot%_bindir/%name-athena
install -pm0644 build-athena/src/emacs.pdmp %buildroot%_emacs_archlibdir/%name-athena.pdmp
%if_enabled natcomp
pushd build-athena
find native-lisp/ -type f -name \*.eln |cpio -pmd %buildroot%_libdir/emacs/%version/
echo native-lisp/* |sed 's,^,%_libdir/%name/%version/,' > ../athena.ls
popd
%else
touch athena.ls
%endif

install -pm0755 build-gtk3/src/emacs %buildroot%_bindir/%name-gtk3
install -pm0644 build-gtk3/src/emacs.pdmp %buildroot%_emacs_archlibdir/%name-gtk3.pdmp
%if_enabled natcomp
pushd build-gtk3
find native-lisp/ -type f -name \*.eln |cpio -pmd %buildroot%_libdir/emacs/%version/
echo native-lisp/* |sed 's,^,%_libdir/%name/%version/,' > ../gtk3.ls
popd
%else
touch gtk3.ls
%endif

install -pm0755 build-pgtk/src/emacs %buildroot%_bindir/%name-pgtk
install -pm0644 build-pgtk/src/emacs.pdmp %buildroot%_emacs_archlibdir/%name-pgtk.pdmp
%if_enabled natcomp
echo build-pgtk/native-lisp/* |sed 's,build-pgtk/,%_libdir/%name/%version/,' > pgtk.ls
%else
touch pgtk.ls
%endif

# remove the installed duplicate emacs binaries
# -- it'll be a link managed by `alternatives':
rm -vf %buildroot%_bindir/emacs
rm -vf %buildroot%_bindir/emacs-%version
rm -vf %buildroot%_emacs_archlibdir/emacs.pdmp

# arch-dependent part of locallisppath, mostly for modules
mkdir %buildroot%_libdir/emacs/%version/site-lisp

# cleanups
sed -i 's,%buildroot,,' %buildroot%_desktopdir/*desktop \
    %buildroot%_libexecdir/systemd/user/emacs.service
mv %buildroot%_bindir/{,g}ctags
mv %buildroot%_man1dir/{,g}ctags.1.gz
rm -vf %buildroot%_infodir/{dir,elisp_type_hierarchy.*}

# alternatives
install -pm644 -D .gear/athena.alternatives %buildroot%_altdir/%name-athena
install -pm644 -D .gear/gtk3.alternatives %buildroot%_altdir/%name-gtk3
install -pm644 -D .gear/pgtk.alternatives %buildroot%_altdir/%name-pgtk

# X resources
install -pm0644 -D .gear/xresources %buildroot%_sysconfdir/X11/app-defaults/Emacs

# file lists
find %buildroot%_libexecdir/emacs/%version \
     %buildroot%_datadir/emacs/%version/etc -type d \
    | sed -e 's,^%buildroot,,' -e 's,^,%%dir ,' > common.ls

find %buildroot%_libexecdir/emacs/%version -type f \
    | sed -e 's,^%buildroot,,' -e '/movemail$/ s,^,%%attr(-\,root\,mail) ,' >> common.ls

find %buildroot%_datadir/emacs/%version/etc -type f \
    | sed -e 's,^%buildroot,,' >> common.ls

find %buildroot%_datadir/emacs/%version/lisp -type d \
    | sed -e 's,^%buildroot,%%dir ,' > lispdirs.ls

find %buildroot%_datadir/emacs/%version/lisp -type f -name \*.el -o -name \*.elc \
    | sed -e 's,^%buildroot,,' > elc.ls

find %buildroot%_datadir/emacs/%version/lisp -type f -name \*.el.gz \
    | sed -e 's,^%buildroot,,' > elgz.ls

sed -e '/\/leim/d' < lispdirs.ls >> common.ls
sed -e '/\/leim\//d' < elc.ls >> common.ls

sed -e '/\/leim\//d' < elgz.ls > el.ls

sed -ne '/\/leim/p' < lispdirs.ls > leim.ls
sed -ne '/\/leim\//p' < elc.ls >> leim.ls
sed -ne '/\/leim\//p' < elgz.ls > leim.el.ls

%set_compress_method skip
%add_debuginfo_skiplist %_libdir/emacs/%version/native-lisp
%brp_strip_none %_libdir/emacs/%version/native-lisp

#---------------------------------------------------------------
%files athena -f athena.ls
%_altdir/%name-athena
%_bindir/%name-athena
%_emacs_archlibdir/%name-athena.pdmp

%files gtk3 -f gtk3.ls
%_altdir/%name-gtk3
%_bindir/%name-gtk3
%_emacs_archlibdir/%name-gtk3.pdmp

%files pgtk -f pgtk.ls
%_altdir/%name-pgtk
%_bindir/%name-pgtk
%_emacs_archlibdir/%name-pgtk.pdmp

%files common -f common.ls
%doc BUGS README
%config(noreplace) %_sysconfdir/X11/app-defaults/*

%_bindir/*
%exclude %_bindir/%name-athena
%exclude %_bindir/%name-gtk3
%exclude %_bindir/%name-pgtk

%dir %_libexecdir/emacs
%exclude %_emacs_archlibdir/*.pdmp

%_libexecdir/systemd/user/emacs.service

%dir %_libdir/emacs/%version
%dir %_libdir/emacs/%version/native-lisp
%_libdir/emacs/%version/site-lisp

%_emacslispdir
%dir %_datadir/emacs/%version
%_datadir/emacs/%version/site-lisp

%_datadir/metainfo/emacs.*.xml
%_desktopdir/*.desktop
%_iconsdir/*/*/*/*
%_man1dir/*.1*

%_includedir/emacs-module.h

%files el -f el.ls

%files leim -f leim.ls

%files leim-el -f leim.el.ls

%files info
%_infodir/*
%exclude %_infodir/eintr*
%exclude %_infodir/elisp*

%files elisp-manual
%_infodir/eintr*
%_infodir/elisp*

%changelog
