Group: System/Base
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-validate
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: eiciel
Version: 0.10.1
%global tar_version %{version}

Release: alt1_3
Summary: Graphical editor for ACLs and xattr
License: GPL-2.0-or-later
URL: http://rofi.roger-ferrer.org/eiciel
Source0: http://rofi.roger-ferrer.org/eiciel/files/eiciel-%{tar_version}.tar.xz

Patch0: eiciel-0.10.1-rawhide-gcc.patch

BuildRequires: meson
BuildRequires: gcc-c++
BuildRequires: pkg-config
BuildRequires: pkgconfig(gtkmm-4.0)
BuildRequires: pkgconfig(libnautilus-extension-4)
BuildRequires: libacl-devel
BuildRequires: itstool
BuildRequires: desktop-file-utils

Requires: icon-theme-hicolor

%global ext_dir %(eval "pkg-config --variable=extensiondir libnautilus-extension-4")

# don't "provide" a private shlib
%global __provides_exclude_from ^%{ext_dir}/.*\\.so$
Source44: import.info


%description
Graphical editor for access control lists (ACLs) and extended attributes
(xattr), either as an extension within Nautilus, or as a standalone
utility.


%prep
%setup -q -n %{name}-%{tar_version}
%patch0 -p1



%build
%meson
%meson_build


%install
%meson_install
%find_lang %{name}
desktop-file-validate %{buildroot}%{_datadir}/applications/*.desktop


%files -f %{name}.lang
%doc AUTHORS
%doc --no-dereference COPYING
%{_bindir}/%{name}
%{_datadir}/help/C/%{name}/
%{_datadir}/applications/*.desktop
%{ext_dir}/lib%{name}*.so
%{_datadir}/metainfo/*.appdata.xml
%{_datadir}/icons/hicolor/*/apps/*%{name}.*
%{_mandir}/man1/%{name}.*


%changelog
