%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

Name:    eg25-manager
Version: 0.5.2
Release: alt5

Summary: Manager daemon for the Quectel EG25 mobile broadband modem
License: GPL-3.0-or-later
Group:   Other
Url:     https://gitlab.com/mobian1/eg25-manager

Source: %name-%version.tar
Source1: mobile-tweaks.conf
Source3: %name.firsttime
Patch0: %name-dirs.patch

BuildRequires(pre): meson
BuildRequires: cmake
BuildRequires: glib2-devel
BuildRequires: libmm-glib-devel
BuildRequires: libgudev-devel
BuildRequires: libgpiod-devel >= 2.0
BuildRequires: libusb-devel
BuildRequires: libcurl-devel

Requires: ModemManager

%description
eg25-manager is a daemon for managing the Quectel EG25 modem found on the
Pine64 PinePhone.

It implements the following features:
* cleanly power on/off the modem
* configure/check essential parameters (such as the audio format) on startup
* monitor the modem state through ModemManager
* put the modem in low-power mode when suspending the system, and restore it
  back to normal behavior when resuming monitor the modem state on resume and
  recover it if needed

%prep
%setup
%autopatch -p1

%build
%meson \
	-Dudevrulesdir=%_udevrulesdir \
	-Dsystemddir=%_systemd_dir \
	-Dsystemdsystemdir=%_unitdir

%meson_build

%install
%meson_install

# For fast on-call wakeups ModemManager needs to be started with
# --test-quick-suspend-resume
install -Dp -m 644 %SOURCE1 %buildroot%_unitdir/ModemManager.service.d/mobile-tweaks.conf

# Disable eg25-manager on unsupported devices during firstinstall
install -Dp -m 755 %SOURCE3 %buildroot%_sysconfdir/firsttime.d/%name

%preun
%preun_service %name

%post
%post_service %name

%triggerin -- %name < 0.5.2-alt4
SYTSEMCTL=systemctl
# Force autostart on supported devices to simplify system upgrade
grep -qi pinephone /proc/device-tree/model 2>/dev/null && $SYSTEMCTL enable eg25-manager || :

%files
%doc *.md
%_bindir/%name
%_unitdir/%name.service
%_unitdir/ModemManager.service.d/mobile-tweaks.conf
%_sysconfdir/firsttime.d/%name
%_udevrulesdir/*.rules
%_datadir/%name

%changelog
