
%global target_arch loongarch64

%if %target_arch == loongarch64
%global efi_target LOONGARCH64
%global efi_platform OvmfPkg/LoongArchVirt/LoongArchVirtQemu.dsc
%global install_dir %_datadir/LA64VMF
%def_without qcow2
%endif

%if %target_arch == riscv64
%global efi_target RISCV64
%global efi_platform OvmfPkg/RiscVVirt/RiscVVirtQemu.dsc
%global install_dir %_datadir/RV64VMF
%def_with qcow2
%endif


%global efi_platform_name %(basename %efi_platform .dsc)

%global optflags_lto %nil

# More subpackages to come once licensing issues are fixed
Name: edk2-%target_arch
Version: 20250808
Release: alt1
Summary: UEFI firmware for %target_arch virtual machines

License: BSD-2-Clause-Patent
Group: Emulators
Url: http://www.tianocore.org

#Vcs-Git: https://github.com/tianocore/edk2.git
Source: edk2.tar
Source1: 80-edk2-loongarch64.json
Source2: 50-edk2-riscv64-qcow2.json


Source10: openssl-snapshot.tar
Source11: pylibfdt-snapshot.tar

Source100: Alt_linux_logo.bmp

# one primary architecture should be enough
ExcludeArch: aarch64 %ix86
BuildArch: noarch

BuildRequires: gcc
BuildRequires: gcc-c++
%if %_build_cpu != %target_arch
BuildRequires: gcc-%target_arch-linux-gnu
%endif

BuildRequires: libuuid-devel
BuildRequires: python3 python3-base
BuildRequires: acpica

%{?_with_qcow2:BuildRequires: qemu-img}

%description
EFI Development Kit II.

UEFI firmware for %target_arch virtual machines.

%prep
%setup -c
pushd edk2

# replace the boot logo
cp -f "%SOURCE100" MdeModulePkg/Logo/Logo.bmp

# don't build BrotliCompress
sed -i '/BrotliCompress/d' BaseTools/Source/C/GNUmakefile

tar --strip-components=1 -xf %SOURCE10 -C CryptoPkg/Library/OpensslLib/openssl
tar --strip-components=1 -xf %SOURCE11 -C MdePkg/Library/BaseFdtLib/libfdt

# include paths pointing to unused submodules
mkdir -p MdePkg/Library/MipiSysTLib/mipisyst/library/include
mkdir -p CryptoPkg/Library/MbedTlsLib/mbedtls/include
mkdir -p CryptoPkg/Library/MbedTlsLib/mbedtls/include/mbedtls
mkdir -p CryptoPkg/Library/MbedTlsLib/mbedtls/library
mkdir -p SecurityPkg/DeviceSecurity/SpdmLib/libspdm/include
mkdir -p Library/BrotliCustomDecompressLib/brotli/c/include
popd

%build
export PYTHON_COMMAND=%__python3
export WORKSPACE=`pwd`
export PACKAGES_PATH=$WORKSPACE/edk2
export EDK_TOOLS_PATH=$WORKSPACE/edk2/BaseTools
export EXTRA_OPTFLAGS="%optflags"
%if %_build_cpu != %target_arch
export GCC5_%{efi_target}_PREFIX='%target_arch-linux-gnu-'
%endif

make -C edk2/BaseTools

source ./edk2/edksetup.sh

build \
    --arch=%efi_target \
    --platform=%efi_platform \
    --tagname=GCC5 \
    --buildtarget=DEBUG \
    -n %__nprocs \
    --pcd gEfiMdeModulePkgTokenSpaceGuid.PcdFirmwareVendor=L"https://www.altlinux.org" \
    --pcd gEfiMdeModulePkgTokenSpaceGuid.PcdFirmwareVersionString=L"%EVR" \
    %nil

%if_with qcow2
for raw in Build/%efi_platform_name/DEBUG_GCC5/FV/*.fd; do
    truncate -s 32M "$raw"
    qemu-img convert -f raw -O qcow2 "$raw" "${raw%%.fd}.qcow2"
    rm -vf "$raw"
done
%endif

%install
mkdir -p %buildroot%install_dir
install -pm 644 -t %buildroot%install_dir \
    Build/%efi_platform_name/DEBUG_GCC5/FV/*.%{?_with_qcow2:qcow2}%{?!_with_qcow2:fd}

mkdir -p %buildroot%_datadir/qemu/firmware
for f in %_sourcedir/*edk2-%{target_arch}*.json; do
    install -pm 644 $f %buildroot%_datadir/qemu/firmware
done

%files
%install_dir
%_datadir/qemu/firmware/*edk2-%{target_arch}*.json

%changelog
