%def_enable snapshot
%define _name editorconfig
%define srcname %_name-core-c
%def_enable docs
%def_disable static
%{?_enable_static:%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}}
%def_disable check

Name: %_name
Version: 0.12.10
Release: alt0.1

Summary: Parser for EditorConfig files written in C
Group: Development/Other
License: BSD-2-Clause
Url: https://editorconfig.org

Vcs: https://github.com/editorconfig/editorconfig-core-c.git

%if_disabled snapshot
Source: https://github.com/%name/%srcname/archive/v%version/%srcname-%version.tar.gz
%else
Source: %srcname-%version.tar
%endif
Patch: %srcname-0.12.5-alt-static_build.patch

Requires: lib%name = %EVR

BuildRequires(pre): cmake >= 3.5.1
BuildRequires: gcc-c++ libpcre2-devel
%{?_enable_docs:BuildRequires: doxygen}

%description
EditorConfig makes it easy to maintain the correct coding style when
switching between different text editors and between different projects.
The EditorConfig project maintains a file format and plugins for various
text editors which allow this file format to be read and used by those
editors.

%package -n lib%name
Summary: EditorConfig shared library
Group: System/Libraries

%description -n lib%name
EditorConfig makes it easy to maintain the correct coding style when
switching between different text editors and between different projects.
The EditorConfig project maintains a file format and plugins for various
text editors which allow this file format to be read and used by those
editors.

This package contains shared EditorConfig library.

%package -n lib%name-devel
Summary: Development files for EditorConfig library
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
EditorConfig makes it easy to maintain the correct coding style when
switching between different text editors and between different projects.
The EditorConfig project maintains a file format and plugins for various
text editors which allow this file format to be read and used by those
editors.

This package contains files needed for development EditorConfig plugins.

%prep
%setup -n %srcname-%version
%patch -b .static

%build
%add_optflags %(getconf LFS_CFLAGS)
%cmake %{?_disable_docs:-DBUILD_DOCUMENTATION=OFF} \
    %{?_disable_static:-DBUILD_STATIC_LIBS=OFF}
%nil
%cmake_build

%install
%cmakeinstall_std

%check
%cmake_build -t tests

%files
%_bindir/%_name
%_bindir/%_name-%version
%{?_enable_docs:%_man1dir/%_name.1.*}
%{?_enable_docs:%_man5dir/%{_name}*}
%doc CHANGELOG README.md LICENSE

%files -n lib%name
%_libdir/lib%_name.so.0*
%{?_enable_static:%exclude %_libdir/*.a}

%files -n lib%name-devel
%_includedir/%_name/
%_libdir/lib%_name.so
%_libdir/cmake/EditorConfig/
%_pkgconfigdir/%_name.pc
%{?_enable_docs:%_man3dir/%{_name}*
%doc %_cmake__builddir/doc/html}

%changelog
