%def_disable clang
%def_enable docs

Name: dtkwidget
Version: 5.7.24
Release: alt1

Summary: Deepin tool kit widget modules

License: LGPL-3.0-or-later
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/dtkwidget
VCS: https://github.com/linuxdeepin/dtkwidget

Packager: Leontiy Volodin <lvol@altlinux.org>

# Source-url: %url/archive/%version/%name-%version.tar.gz
Source: %name-%version.tar
Patch0: %name-%version-%release.patch
Patch1: dtkwidget-5.6.28-alt-pkgconfig-find-requires.patch

# for webp (dci) icons
Requires: dqt5-imageformats

# find libraries
%add_findprov_lib_path %_dqt5_libdir

%if_enabled clang
BuildRequires(pre): clang-devel
%else
BuildRequires(pre): gcc-c++
%endif
BuildRequires(pre): rpm-build-ninja rpm-macros-dqt5
# Automatically added by buildreq on Thu Oct 19 2023
# optimized out: cmake-modules gcc-c++ glibc-kernheaders-generic glibc-kernheaders-x86 libX11-devel libXext-devel libXfixes-devel libXi-devel libdouble-conversion3 libdtkcore-devel libglvnd-devel libgpg-error libgsettings-qt libp11-kit libdqt5-concurrent libdqt5-core libdqt5-dbus libdqt5-gui libdqt5-help libdqt5-network libdqt5-printsupport libdqt5-sql libdqt5-svg libdqt5-widgets libdqt5-x11extras libdqt5-xml libsasl2-3 libssl-devel libstartup-notification libstdc++-devel libxcb-devel pkg-config python3 python3-base dqt5-base-common dqt5-base-devel dqt5-tools sh5 xorg-proto-devel
BuildRequires: cmake doxygen dtk6-common-devel libgsettings-qt-devel libcups-devel libdtkgui-devel libstartup-notification-devel libxcbutil-devel dqt5-svg-devel dqt5-tools-devel dqt5-x11extras-devel libwayland-client-devel

%description
DtkWidget is Deepin graphical user interface for deepin desktop development.

%package -n lib%{name}5
Summary: Libraries for %name
Group: System/Libraries
Provides: libdtk5-widget = %EVR
Obsoletes: libdtk5-widget < %EVR
Requires: libdqt5-core = %_dqt5_version
Requires: libdqt5-gui = %_dqt5_version
Requires: libdqt5-printsupport = %_dqt5_version
Requires: libdqt5-widgets = %_dqt5_version

%description -n lib%{name}5
DtkWidget is Deepin graphical user interface for deepin desktop development.
Libraries for %name.

%package -n lib%name-devel
Summary: Development package for %name
Group: Development/KDE and QT
Provides: dtk5-widget-devel = %EVR
Obsoletes: dtk5-widget-devel < %EVR

%description -n lib%name-devel
Header files and libraries for %name.

%package examples
Summary: Examples for %name
Group: Development/KDE and QT
Provides: dtk5-widget-examples = %EVR
Obsoletes: dtk5-widget-examples < %EVR

%description examples
DtkWidget is Deepin graphical user interface for deepin desktop development.
Examples for %name.

%if_enabled docs
%package doc
Summary: %name documantation
Group: Documentation
BuildArch: noarch
Provides: dtk5-widget-doc = %EVR
Obsoletes: dtk5-widget-doc < %EVR

%description doc
This package provides %name documantation.
%endif

%prep
%setup
%patch0 -p1
%patch1 -p1

%build
%if_enabled clang
export CC="clang"
export CXX="clang++"
export AR="llvm-ar"
export NM="llvm-nm"
export READELF="llvm-readelf"
%endif
export PATH=%_dqt5_bindir:$PATH
%cmake \
  -GNinja \
  -DCMAKE_BUILD_TYPE=None \
  -DCMAKE_PREFIX_PATH=%_dqt5_libdir/cmake \
  -DCMAKE_SKIP_INSTALL_RPATH:BOOL=no \
  -DCMAKE_INSTALL_RPATH=%_dqt5_libdir \
  -DMKSPECS_INSTALL_DIR=%_dqt5_archdatadir/mkspecs/modules/ \
%if_enabled docs
  -DBUILD_DOCS=ON \
  -DQCH_INSTALL_DESTINATION=%_dqt5_docdir \
%else
  -DBUILD_DOCS=OFF \
%endif
  -DCMAKE_INSTALL_PREFIX=%_prefix \
  -DCMAKE_INSTALL_LIBDIR=%_lib \
  -DDTK_VERSION=%version \
  -DBUILD_PLUGINS=OFF \
#
cmake --build %_cmake__builddir -j%__nprocs

%install
%cmake_install

%files
%doc README.md LICENSE CHANGELOG.md
%dir %_libdir/dtk5/
%dir %_libdir/dtk5/DWidget/
%_libdir/dtk5/DWidget/bin/
%dir %_datadir/dtk5/
%_datadir/dtk5/DWidget/

%files -n lib%{name}5
%_libdir/lib%name.so.5*

%files -n lib%name-devel
%dir %_includedir/dtk5/
%_includedir/dtk5/DWidget/
%_dqt5_archdatadir/mkspecs/modules/*.pri
%_libdir/cmake/DtkWidget/
%_pkgconfigdir/%name.pc
%_libdir/lib%name.so

%files examples
%dir %_libdir/dtk5/DWidget/
%_libdir/dtk5/DWidget/examples/

%files doc
%_dqt5_docdir/dtkwidget.qch

%changelog
