%define _libexecdir %_prefix/libexec

%def_disable clang

Name: dtkgui
Version: 5.7.24
Release: alt1

Summary: Deepin Toolkit, gui module for DDE look and feel

License: LGPL-3.0-or-later
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/dtkgui
VCS: https://github.com/linuxdeepin/dtkgui

Packager: Leontiy Volodin <lvol@altlinux.org>

# Source-url: %url/archive/%version/%name-%version.tar.gz
Source: %name-%version.tar
Patch0: %name-%version-%release.patch
Patch1: dtkgui-alt-git.patch

BuildRequires(pre): rpm-build-ninja rpm-macros-dqt5
# dqt5-base-devel-static -> libQt5XkbCommonSupport.a
# Automatically added by buildreq on Tue Jul 22 2025
# optimized out: cmake cmake-modules dqt5-base-devel gcc-c++ glib2-devel glibc-devel-static glibc-kernheaders-generic glibc-kernheaders-x86 libX11-devel libcairo-devel libdouble-conversion3 libdqt5-core libdqt5-dbus libdqt5-gui libdqt5-network libdqt5-svg libdqt5-waylandclient libdqt5-widgets libdqt5-xml libdtklog-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libglvnd-devel libgpg-error libgsettings-qt1 liblcms2-devel libp11-kit libsasl2-3 libssl-devel libstdc++-devel libwayland-client libwayland-client-devel libwayland-cursor libxkbcommon-devel pkg-config python3 python3-base sh5 wayland-devel xorg-proto-devel
BuildRequires: dqt5-base-devel-static dqt5-svg-devel dqt5-wayland-devel dtk6-common-devel extra-cmake-modules libdtkcore-devel libfreeimage-devel libgomp-devel libqtxdg-devel libraw-devel librsvg-devel treeland-protocols
# BuildRequires: libpcre2-devel libffi-devel libmount-devel libblkid-devel libselinux-devel libjpeg-devel libtiff-devel bzlib-devel libbrotli-devel libexpat-devel libpixman-devel
# BuildRequires: libXdmcp-devel
%if_enabled clang
BuildRequires: clang-devel
%else
BuildRequires: gcc-c++ libgomp-devel
%endif

%description
Deepin Toolkit, gui module for DDE look and feel.

%package -n lib%{name}5
Summary: Library for %name
Group: System/Libraries
Provides: libdtk5-gui = %EVR
Obsoletes: libdtk5-gui < %EVR
Requires: libdqt5-core = %_dqt5_version
Requires: libdqt5-gui = %_dqt5_version
Requires: libdqt5-waylandclient = %_dqt5_version

%description -n lib%{name}5
DtkGui is used for DDE look and feel.
This package contains the shared libraries.

%package -n lib%{name}-devel
Summary: Development package for %name
Group: Graphical desktop/Other
Provides: dtk5-gui-devel = %EVR
Obsoletes: dtk5-gui-devel < %EVR

%description -n lib%{name}-devel
Header files and libraries for %name.

%prep
%setup
%patch0 -p1
%patch1 -p1

%build
%add_optflags -I/usr/lib/gcc/%{_target_alias}/%{get_version libgomp-devel}/include
%if_enabled clang
export CC="clang"
export CXX="clang++"
export AR="llvm-ar"
export NM="llvm-nm"
export READELF="llvm-readelf"
%endif
export PATH=%_dqt5_bindir:$PATH
export CMAKE_PREFIX_PATH=%_dqt5_libdir/cmake:$CMAKE_PREFIX_PATH
%cmake \
  -GNinja \
  -DCMAKE_BUILD_TYPE=RelWithDebInfo \
  -DCMAKE_SKIP_INSTALL_RPATH:BOOL=no \
  -DCMAKE_INSTALL_RPATH=%_dqt5_libdir \
  -DMKSPECS_INSTALL_DIR=%_dqt5_archdatadir/mkspecs/modules/ \
  -DPACKAGE_TOOL_INSTALL_DIR=libexec/dtk5/DGui/bin \
  -DCMAKE_INSTALL_LIBDIR=%_lib \
  -DLIB_INSTALL_DIR=%_libdir \
  -DLIBRARY_INSTALL_DIR=%_lib \
  -DDTK_VERSION=%version \
  -DBUILD_DOCS=OFF \
  %if_enabled clang
  -DLLVM_USE_LINKER=lld \
  %endif
#
cmake --build %_cmake__builddir -j%__nprocs

%install
%cmake_install

%files
%doc README.md LICENSE
%dir %_libexecdir/dtk5/
%dir %_libexecdir/dtk5/DGui/
%_libexecdir/dtk5/DGui/bin/

%files -n lib%{name}5
%_libdir/libdtkgui.so.5*

%files -n lib%{name}-devel
%dir %_includedir/dtk5/
%_includedir/dtk5/DGui/
%_dqt5_archdatadir/mkspecs/modules/qt_lib_dtkgui.pri
%dir %_libdir/cmake/DtkGui/
%_libdir/cmake/DtkGui/DtkGuiConfig.cmake
%_libdir/cmake/DtkGui/DtkGuiConfigVersion.cmake
%_libdir/cmake/DtkGui/DtkGuiTargets*.cmake
%_pkgconfigdir/dtkgui.pc
%_libdir/libdtkgui.so

%changelog
