%global qt_module dqtxmlpatterns

Name: dqt5-xmlpatterns
Version: 5.15.13
Release: alt0.dde.1
# %%if "%%version" == "%%{get_version dqt5-tools-common}"
%def_disable bootstrap
# %%else
# %%def_enable bootstrap
# %%endif

Group: System/Libraries
Summary: Qt5 - QtXmlPatterns component
Url: http://qt.io/
License: LGPL-2.1 with Qt-LGPL-exception-1.1 or LGPL-3.0-only

Source: %qt_module-everywhere-src-%version.tar

BuildRequires(pre): rpm-macros-dqt5
# BuildRequires(pre): dqt5-tools-common
# %%if_disabled bootstrap
# BuildRequires: dqt5-tools
# %%endif
BuildRequires: gcc-c++ glibc-devel dqt5-base-devel dqt5-declarative-devel

# find libraries
%add_findprov_lib_path %_dqt5_libdir

%description
The Qt XML Patterns module provides support for XPath, XQuery, XSLT,
and XML Schema validation.

%package common
Summary: Common package for %name
Group: System/Configuration/Other
BuildArch: noarch
Requires: dqt5-base-common
%description common
Common package for %name

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: dqt5-base-devel
%description devel
%summary.

%package devel-static
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: %name-devel
%description devel-static
%summary.

%package doc
Summary: Document for developing apps which will use Qt5 %qt_module
Group: Development/KDE and QT
Requires: %name-common = %EVR
%description doc
This package contains documentation for Qt5 %qt_module

%package -n libdqt5-xmlpatterns
Summary: Qt5 library
Group: System/Libraries
Requires: %name-common = %EVR
Requires: libdqt5-core = %_dqt5_version
%description -n libdqt5-xmlpatterns
%summary

%prep
%setup -n %qt_module-everywhere-src-%version
syncqt.pl-dqt5 -version %version

%build
%define qdoc_found %{expand:%%(if [ -e %_dqt5_bindir/qdoc ]; then echo 1; else echo 0; fi)}

%qmake_dqt5
%make_build
%if %qdoc_found
export QT_HASH_SEED=0
%make docs
%endif

%install
%install_dqt5
%if %qdoc_found
%make INSTALL_ROOT=%buildroot install_docs ||:
%endif

%files common
%files -n libdqt5-xmlpatterns
%doc LICENSE*EXCEPT*
%_dqt5_libdir/libQt?XmlPatterns.so.*
%_dqt5_qmldir/QtQuick/XmlListModel/

%files devel
%_dqt5_bindir/xmlpatterns*
%_bindir/xmlpatterns*
%_dqt5_headerdir/Qt*/
%_dqt5_libdir/libQt*.so
%_dqt5_libdatadir/libQt*.so
%_dqt5_libdir/libQt*.prl
%_dqt5_libdatadir/libQt*.prl
%_dqt5_libdir/cmake/Qt*/
%_dqt5_libdir/pkgconfig/Qt*.pc
%_dqt5_archdatadir/mkspecs/modules/*.pri

%files doc
%if %qdoc_found
%_dqt5_docdir/*
%endif
%_dqt5_examplesdir/*

%changelog
