Name: doxygen
Version: 1.15.0
Release: alt1
Epoch: 1

Summary: Doxygen is a documentation system for C, C++ and IDL
License: GPLv2+
Group: Development/Other
Url: http://www.doxygen.org/

# ftp://ftp.stack.nl/pub/users/dimitri/doxygen-%version.src.tar.gz
Source: %name-%version.src.tar.gz
Source500: %name.unused

## Ubuntu patches
Patch101: Ubuntu-manpages.patch
Patch102: Ubuntu-dot-config.patch
Patch104: Ubuntu-avoid-compass.patch
Patch107: Ubuntu-libatomic.patch
Patch108: Ubuntu-reproducible_manpages.patch
Patch109: Ubuntu-sass_fix.patch

## ALT patches

BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: flex bison
BuildRequires: /usr/bin/epstopdf
BuildRequires: git-core
BuildRequires: graphviz
BuildRequires: perl
BuildRequires: texlive-collection-basic texlive-dist
BuildRequires: qt5-base-devel
BuildRequires: qt5-svg-devel
BuildRequires: sassc node-uglify-js

# graphviz uses pango as the default backend. pango needs some font and
# a properly configured fontconfig to produce something sane.
BuildRequires: fontconfig fonts-ttf-dejavu
Requires: fontconfig fonts-ttf-dejavu

%description
Doxygen is a documentation system for C, C++ and IDL.  It can generate
an on-line class browser (in HTML) and/or an off-line reference manual
(in LaTeX) from a set of documented source files.  There is also support
for generating man pages and for converting the generated output into
Postscript, hyperlinked PDF or compressed HTML.  The documentation is
extracted directly from the sources.

Doxygen can also be configured to extract the code-structure from
undocumented source files.  This can be very useful to quickly find
your way in large source distributions.

%package wizard
Summary: GUI frontend for doxygen
Group: Development/Other
Requires: %name = %epoch:%version-%release

%description wizard
Doxywizard is a GUI front-end for creating and editing
configuration files that are used by doxygen.

%package doc
Summary: Documentation and examples for doxygen
Group: Development/Other
BuildArch: noarch
Requires: %name = %epoch:%version-%release

%description doc
This package contains doxygen examples and documentation in html and
pdf formats.

%prep
%setup

## Remove junk
find * -name "*._*" -delete

## Ubuntu apply patches
%patch101 -p1
%patch102 -p1
%patch104 -p1
%patch107 -p1
%patch108 -p1
%patch109 -p1

## ALT apply patches

%build
%ifnarch %ix86
# node and/or uglifyjs are broken on i586, see
# - https://bugzilla.altlinux.org/55012
# - https://bugzilla.altlinux.org/54577
%make_build -C deps/jquery \
	UGLIFYJS=uglifyjs \
	install
%endif

%define _cmake__builddir BUILD
%cmake -G "Unix Makefiles" \
	-Dbuild_doc=ON -Dbuild_wizard=ON -Dbuild_xmlparser=ON \
	-Dbuild_search=OFF \
	-DMAN_INSTALL_DIR=%_mandir/man1 \
	-DDOC_INSTALL_DIR=share/doc/%name-%version \
	-DCMAKE_INSTALL_PREFIX:PATH=%prefix
%cmake_build

export NPROCS=1
%cmake_build -t docs

%install
%cmakeinstall_std

%check
cd BUILD && make tests

%files
%doc README.md
%_bindir/doxygen
%_man1dir/doxygen.*

%files wizard
%_bindir/doxywizard
%_man1dir/doxywizard.*

%files doc
%_defaultdocdir/%name-%version
%exclude %_defaultdocdir/%name-%version/README.md

%changelog
