Name: domoticz
Version: 2023.2
Release: alt1

Summary: Open source Home Automation System

License: GPLv3+ and Apache-2.0 and Boost and BSD and MIT
Group: Other
Url: http://www.domoticz.com

# Source-url: https://github.com/domoticz/domoticz/archive/%version.tar.gz
Source: %name-%version.tar

Source1: %name.service
Source2: %name.conf
# Manually update version reported inside app
Source3: %name-appversion

# Use system tinyxpath (https://github.com/domoticz/domoticz/pull/1759)
Patch1: %name-tinyxpath.patch
# Fix python detection (https://github.com/domoticz/domoticz/pull/1749)
Patch2: %name-python.patch
# Python linking fix
Patch3: %name-python-link.patch

Patch4: %name-string.patch

AutoReq: yes, noperl, nolua
AutoProv: no

BuildRequires: boost-program_options-devel boost-signals-devel boost-asio-devel
BuildRequires: cereal-devel
BuildRequires: cmake
BuildRequires: curl-devel
BuildRequires: libfmt-devel
BuildRequires: fontpackages-devel
BuildRequires: gcc-c++
# TODO: remove
BuildRequires: git
BuildRequires: jsoncpp-devel
BuildRequires: libopenzwave-devel >= 1.6
BuildRequires: pkgconfig(libusb-1.0)
BuildRequires: liblua5-devel
#BuildRequires: minizip-compat-devel
BuildRequires: libminizip-devel
BuildRequires: libmosquitto-devel
BuildRequires: libssl-devel
BuildRequires: python3-devel
BuildRequires: libsqlite3-devel
BuildRequires: libudev-devel
#BuildRequires: tinyxpath-devel
BuildRequires: zlib-devel

Requires(pre):	shadow-utils
Requires(post):	udev-rules
Requires(postun):	udev-rules
Requires(preun):	udev-rules

#Requires: fonts-ttf-google-droid-all
#Recommends:	system-python-libs >= 3.4

%add_python3_lib_path %_datadir/%name
%add_python3_req_skip Domoticz DomoticzEvents DomoticzEx
%add_python3_req_skip bluepy

%description
Domoticz is a Home Automation System that lets you monitor and configure various
devices like: Lights, Switches, various sensors/meters like Temperature, Rain,
Wind, UV, Electra, Gas, Water and much more. Notifications/Alerts can be sent to
any mobile device

%prep
%setup
#patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

# Add support for future versions of Python by replacing hardcoded version with macro
%__subst 's/-lpythonVER/-lpython%__python3_version/' CMakeLists.txt
cp -p %SOURCE3 ./appversion.h

%build
%cmake \
 -DCMAKE_BUILD_TYPE=RelWithDebInfo \
 -DUSE_STATIC_LIBSTDCXX=NO \
 -DUSE_STATIC_OPENZWAVE=NO \
 -DUSE_OPENSSL_STATIC=NO \
 -DUSE_BUILTIN_JSONCPP=NO \
 -DUSE_BUILTIN_LIBFMT=NO \
 -DUSE_BUILTIN_LUA=NO \
 -DUSE_BUILTIN_MINIZIP=NO \
 -DUSE_BUILTIN_MQTT=NO \
 -DUSE_BUILTIN_SQLITE=NO \
 -DUSE_BUILTIN_TINYXPATH=NO \
 -DUSE_STATIC_BOOST=NO \
 -DCMAKE_INSTALL_PREFIX=%_datadir/%name \
 %nil
%cmake_build

%install
%cmake_install

# remove bundled OpenZWave configuration files so system files are used
rm -rv %buildroot%_datadir/%name/Config/

# remove docs, we grab them in files below
rm -v %buildroot%_datadir/%name/*.txt

# move binary to standard directory
mkdir -p %buildroot%_bindir/
mv %buildroot%_datadir/%name/%name %buildroot%_bindir/

# install systemd service and config
mkdir -p %buildroot%_sysconfdir/sysconfig/
mkdir -p %buildroot%_unitdir/
cp -p %SOURCE1 %buildroot%_unitdir/
cp -p %SOURCE2 %buildroot%_sysconfdir/sysconfig/%name

# create backups/database/plugins/scripts/ssl cert directory
mkdir -p %buildroot%_sharedstatedir/%name/{backups,plugins,scripts,templates}
mkdir -p %buildroot%_sharedstatedir/%name/scripts/{dzVents,lua,lua_parsers,python,templates}
mkdir -p %buildroot%_sharedstatedir/%name/scripts/dzVents/{data,generated_scripts,scripts}

# Disable the app's self-update script
chmod 644 %buildroot%_datadir/%name/updatedomo

# Unbundle DroidSans.ttf
#rm -f %buildroot%_datadir/%name/www/styles/elemental/fonts/DroidSans.ttf
#ln -s %_fontdir/google-droid/DroidSans.ttf \
#%buildroot%_datadir/%name/www/styles/elemental/fonts/
#rm -f %buildroot%_datadir/%name/www/styles/element-light/fonts/DroidSans.ttf
#ln -s %_fontdir/google-droid/DroidSans.ttf \
#%buildroot%_datadir/%name/www/styles/element-light/fonts/
#rm -f %buildroot%_datadir/%name/www/styles/element-dark/fonts/DroidSans.ttf
#ln -s %_fontdir/google-droid/DroidSans.ttf \
#%buildroot%_datadir/%name/www/styles/element-dark/fonts/

# Link default plugins and scripts to userdata directory
ln -s %_datadir/%name/scripts/dzVents/data/README.md \
%buildroot%_sharedstatedir/%name/scripts/dzVents/data/README.md
ln -s %_datadir/%name/scripts/dzVents/generated_scripts/README.md \
%buildroot%_sharedstatedir/%name/scripts/dzVents/generated_scripts/README.md
ln -s %_datadir/%name/scripts/dzVents/scripts/README.md \
%buildroot%_sharedstatedir/%name/scripts/dzVents/scripts/README.md
ln -s %_datadir/%name/scripts/templates/All.{dzVents,Lua,Python} \
%buildroot%_sharedstatedir/%name/scripts/templates/
ln -s %_datadir/%name/scripts/templates/Bare.dzVents \
%buildroot%_sharedstatedir/%name/scripts/templates/
ln -s %_datadir/%name/scripts/templates/Device.{dzVents,Lua} \
%buildroot%_sharedstatedir/%name/scripts/templates/
ln -s %_datadir/%name/scripts/templates/global_data.dzVents \
%buildroot%_sharedstatedir/%name/scripts/templates/
ln -s %_datadir/%name/scripts/templates/Group.dzVents \
%buildroot%_sharedstatedir/%name/scripts/templates/
ln -s %_datadir/%name/scripts/templates/HTTPRequest.dzVents \
%buildroot%_sharedstatedir/%name/scripts/templates/
ln -s %_datadir/%name/scripts/templates/Scene.dzVents \
%buildroot%_sharedstatedir/%name/scripts/templates/
ln -s %_datadir/%name/scripts/templates/Security.{dzVents,Lua} \
%buildroot%_sharedstatedir/%name/scripts/templates/
ln -s %_datadir/%name/scripts/templates/Time.Lua \
%buildroot%_sharedstatedir/%name/scripts/templates/
ln -s %_datadir/%name/scripts/templates/Timer.dzVents \
%buildroot%_sharedstatedir/%name/scripts/templates/
ln -s %_datadir/%name/scripts/templates/UserVariable.{dzVents,Lua} \
%buildroot%_sharedstatedir/%name/scripts/templates/

# Link web page templates to userdata directory
mv %buildroot%_datadir/%name/www/templates/{custom.example,readme.txt} \
%buildroot%_sharedstatedir/%name/templates
rm -rf %buildroot%_datadir/%name/www/templates
ln -s %_sharedstatedir/%name/templates \
%buildroot%_datadir/%name/www/templates


%pre
groupadd -f -r domoticz
useradd -r -g domoticz -d %_datadir/%name -s /sbin/nologin \
  -c "Domoticz Home Automation Server" domoticz || :
# For OpenZWave USB access (/dev/ttyACM#)
usermod -a -G dialout domoticz || :
usermod -a -G uucp domoticz || :

%post
%post_service %name

%preun
%preun_service %name

%files
%doc License.txt
%doc README.md History.txt
%_bindir/%name
%config(noreplace) %_sysconfdir/sysconfig/%name
%_datadir/%name/
%attr(0755,domoticz,domoticz) %_sharedstatedir/%name/
%_unitdir/%name.service

%changelog
