Name: docbook-style-dsssl
Version: 1.79
Release: alt3
Summary: Modular stylesheets for DocBook by Norman Walsh
Group: Publishing
License: Distributable
URL: http://sourceforge.net/projects/docbook/
Requires: jade >= 1.2.1
Requires: docbook-dtds
Requires: sgml-common >= 0.5
BuildArch: noarch
Source0: http://prdownloads.sourceforge.net/docbook/docbook-dsssl-%version.tar
Source1: %name-%version.Makefile

%define sgmlbase %_datadir/sgml
%define sgmlconfdir %_sysconfdir/sgml

%description
These DSSSL stylesheets allow to convert any DocBook document to another
printed (for example, RTF or PostScript) or online (for example, HTML)
format. They are highly customizable.


%package utils
Summary: utilities for DocBook modular stylesheets
Group: Publishing

%description utils
This package contains a Perl script named collateindex.pl, which is used
to create index data for DocBook XML or SGML files.


%prep
%setup -n docbook-dsssl-%version
sed -i '1 s/^\(#![^#]*\)#.*/\1/' bin/collateindex.pl


%install
%makeinstall -f %SOURCE1
cp -a contrib %buildroot%sgmlbase/docbook/dsssl-stylesheets-%version/
ln -sf dsssl-stylesheets-%version %buildroot%sgmlbase/docbook/dsssl-stylesheets


%post
find %sgmlconfdir -type f \( -name 'sgml-docbook-*.cat' -o -name 'xml-docbook-*.cat' \) -print |
while read -r catalog; do
	%_bindir/install-catalog --add "$catalog" \
		%sgmlbase/docbook/dsssl-stylesheets-%version/catalog \
		>/dev/null 2>&1
done


%postun
if [ $1 = 0 -o ! -f %sgmlbase/docbook/dsssl-stylesheets-%version/catalog ]; then
	find %sgmlconfdir -type f \
		\( -name 'sgml-docbook-*.cat' -o -name 'xml-docbook-*.cat' \) -print |
	while read -r catalog; do
		%_bindir/install-catalog --remove "$catalog" \
			%sgmlbase/docbook/dsssl-stylesheets-%version/catalog \
			>/dev/null 2>&1
	done
fi


%triggerun -- %name < 1.78-alt2
DSLCATALOGS=$(echo %sgmlbase/docbook/dsssl-stylesheets-?.??*/catalog)
[ "$DSLCATALOGS" = '%sgmlbase/docbook/dsssl-stylesheets-?.??*/catalog' ] ||
find %sgmlconfdir -type f \
	\( -name 'sgml-docbook-*.cat' -o -name 'xml-docbook-*.cat' \) -print |
while read -r catalog; do
	for dslcatalog in $DSLCATALOGS; do
		[ "$dslcatalog" = %sgmlbase/docbook/dsssl-stylesheets-%version/catalog ] ||
		%_bindir/install-catalog --remove "$catalog" $dslcatalog >/dev/null 2>&1
	done
done


%files
%doc BUGS README ChangeLog WhatsNew RELEASE-NOTES.*
%sgmlbase/docbook/*


%files utils
%_bindir/*
%_man1dir/*


%changelog
