%def_disable debug

Name: dmraid
Version: 1.0.0.rc16
Release: alt4

Summary: dmraid (Device-mapper RAID tool and library)
Group: System/Base
License: GPL-2.0-or-later and LGPL-2.1
Url: http://people.redhat.com/heinzm/sw/dmraid

Source: dmraid-%version.tar.bz2
Patch: dmraid-1.0.0.rc16-alt-DSO.patch
Patch1: dmraid-1.0.0.rc16-alt-Makefile.patch
Patch2: dmraid-1.0.0.rc16-alt-fix-build-with-static-libdevmapper.patch

#fc
Patch10: dmraid-1.0.0.rc16-test_devices.patch
Patch11: ddf1_lsi_persistent_name.patch
Patch12: pdc_raid10_failure.patch
Patch13: return_error_wo_disks.patch
Patch14: fix_sil_jbod.patch
Patch15: avoid_register.patch
Patch16: move_pattern_file_to_var.patch
Patch17: libversion.patch
Patch18: libversion-display.patch
Patch19: bz635995-data_corruption_during_activation_volume_marked_for_rebuild.patch
Patch21: bz626417_19-enabling_registration_degraded_volume.patch
Patch22: bz626417_20-cleanup_some_compilation_warning.patch
Patch23: bz626417_21-add_option_that_postpones_any_metadata_updates.patch
Patch24: dmraid-fix-build-to-honour-cflags-var.patch

Requires: kpartx

BuildRequires: libdevmapper-devel libdevmapper-event-devel libdevmapper-devel-static

%description
DMRAID supports RAID device discovery, RAID set activation and display of
properties for ATARAID on Linux >= 2.4 using device-mapper.

%package devel
Summary: Development libraries and headers for dmraid.
Group: Development/C
Requires: %name = %version-%release

%description devel
dmraid-devel provides a library interface for RAID device discovery,
RAID set activation and display of properties for ATARAID volumes.


%prep
%setup
%patch
%patch1 -p1
%patch2 -p2

# fc
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1

%build
%add_optflags -Wno-error=implicit-int -Wno-error=return-mismatch
%define opt %{subst_enable debug} --sbindir=/sbin
%configure  %opt --enable-static_link
# SMP incompatible build
%make
mv tools/dmraid tools/dmraid.static
%make clean
%configure %opt --enable-shared_lib
%make

%install
%makeinstall_std
install -m 755 tools/dmraid.static %buildroot/sbin/dmraid.static
rm -f %buildroot/%_libdir/lib%name.a

%files
/sbin/dmevent_tool
/sbin/dmraid
/sbin/dmraid.static
%_libdir/lib%name.so.*
%_libdir/lib%name-events-isw.so.*
%_man8dir/dmevent_tool.8.*
%_man8dir/dmraid.8.*
%doc CHANGELOG CREDITS KNOWN_BUGS LICENSE 
%doc README TODO doc/dmraid_design.txt

%files devel
%_includedir/%name/
%_libdir/lib%name.so
%_libdir/lib%name-events-isw.so

%changelog
