Name: djvu
Version: 3.5.29
Release: alt1

Summary: DjVu viewers, encoders and utilities
License: GPLv2+
Group: Publishing
Url: http://djvu.sourceforge.net/

# http://download.sourceforge.net/djvu/djvulibre-%version.tar.gz
Source: djvulibre-%version.tar
Patch0: djvulibre-3.5.22-rh-cdefs.patch
# https://bugzilla.altlinux.org/16141
Patch1: any2djvu-exit-code-fix.patch
# CVE-2021-46312
Patch2: RH-0001-Check-for-zero-width-and-height.patch


# Automatically added by buildreq on Sat Apr 13 2013
# optimized out: libstdc++-devel
BuildRequires: gcc-c++ libjpeg-devel libtiff-devel xdg-utils

%def_disable static

%description
DjVu is a web-centric format and software platform for distributing documents
and images. DjVu can advantageously replace PDF, PS, TIFF, JPEG, and GIF for
distributing scanned documents, digital documents, or high-resolution pictures.
DjVu content downloads faster, displays and renders faster, looks nicer on a
screen, and consume less client resources than competing formats. DjVu images
display instantly and can be smoothly zoomed and panned with no lengthy
re-rendering.

DjVuLibre is a free (GPL'ed) implementation of DjVu, including decoders,
simple encoders, and utilities.  The viewer and browser plugin are in
their own separate packages.

%package common
Summary: DjVu shared files
Group: Publishing
BuildArch: noarch

%description common
DjVu is a web-centric format and software platform for distributing documents
and images. DjVu can advantageously replace PDF, PS, TIFF, JPEG, and GIF for
distributing scanned documents, digital documents, or high-resolution pictures.
DjVu content downloads faster, displays and renders faster, looks nicer on a
screen, and consume less client resources than competing formats. DjVu images
display instantly and can be smoothly zoomed and panned with no lengthy
re-rendering.

This package contains data files shared among DjVu subpackages.

%package -n lib%name
Summary: DjVu encoder runtime library
Group: System/Libraries
Requires: %name-common = %EVR

%description -n lib%name
This package contains DjVu encoder runtime library.

%package utils
Summary: DjVu utilites
Group: Publishing
Requires: lib%name = %EVR

%description utils
This package contains DjVu encoder and support utilites.

%package xmltools
Summary: DjVu XML tools
Group: Publishing
Requires: lib%name = %EVR

%description xmltools
This package contains DjVu XML tools.

%package doc
Summary: DjVu documenation
Group: Publishing
BuildArch: noarch

%description doc
This package contains documentaion about DjVu technology,
can be also used as test samples.

%package -n lib%name-devel
Summary: Development files for lib%name
Group: Development/C++
Requires: lib%name = %EVR
Provides: %name-devel = %EVR
Obsoletes: %name-devel < %EVR

%description -n lib%name-devel
This package contains development files for lib%name.

%package -n lib%name-devel-static
Summary: static version of libdjvu
Group: Development/C++
Requires: lib%name-devel = %EVR

%description -n lib%name-devel-static
Static version of lib%name for apps using DjVu
technology.

%prep
%setup -n djvulibre-%version
%patch0 -p1
%patch1 -p2
%patch2 -p1

%build
%autoreconf
%configure %{subst_enable static} --enable-threads
%make_build V=1 OPTS='%optflags' \
	PNGICONS="$(cd desktopfiles && echo prebuilt-hi*-djvu.png |sed s/prebuilt-//g)"

%install
%makeinstall_std \
	PNGICONS="$(cd desktopfiles && echo prebuilt-hi*-djvu.png |sed s/prebuilt-//g)"
find %buildroot%_datadir/djvu -name 'prebuilt-hi*-djvu.png' -delete

pushd desktopfiles
for f in hi*-djvu.png; do
	i=${f%%-djvu.png};
	i=${i#hi}
	install -Dpm644 "$f" \
		%buildroot%_iconsdir/hicolor/"$i"x"$i"/mimetypes/image-vnd.djvu.mime.png
done
install -Dpm644 djvulibre-mime.xml %buildroot%_datadir/mime/packages/djvulibre-mime.xml
popd

%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir
cp -a COPYRIGHT NEWS README doc %buildroot%docdir/

%find_lang %name
# lfs function check fails on ix86
%ifnarch %ix86
%set_verify_elf_method strict
%endif

%files common
%_datadir/djvu/
%_iconsdir/*/*/*/*.png
%_iconsdir/*/scalable/*/*.svgz
%_datadir/mime*/*
%dir %docdir/
%docdir/[CNR]*

%files doc
%dir %docdir/
%docdir/doc/

%files -f %name.lang -n lib%name
%_libdir/*.so.*

%files utils
%_bindir/*
%_mandir/man?/*
%exclude %_bindir/*xml*
%exclude %_mandir/man?/*xml*

%files xmltools
%_bindir/*xml*
%_mandir/man?/*xml*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif #static

%changelog
