%define _unpackaged_files_terminate_build 1
%define up_name DisplayCAL

Name: displaycal
Version: 3.9.16
Release: alt1

Summary: A graphical user interface for the Argyll CMS display calibration utilities

Group: Graphics
License: GPL-3.0
Url: https://pypi.org/project/displaycal/
Vcs: https://github.com/eoyilmaz/displaycal-py3
Packager: Vitaly Lipatov <lav@altlinux.ru>
BuildArch: noarch
# Source-url: https://github.com/eoyilmaz/displaycal-py3/releases/download/%version/DisplayCAL-%version.tar.gz
Source: %name-%version.tar

Patch1: displaycal-3.9.11-udev-dir.patch
Patch2: displaycal-skip-update-check.patch
Patch3: displaycal-3.9.8-fix-autostart-location.patch

BuildRequires(pre): rpm-build-python3 rpm-build-intro
BuildRequires: python3-module-wheel
BuildRequires: python3-module-setuptools
BuildRequires: xdg-user-dirs

Requires: argyllcms

AutoProv: no

Provides: %up_name = %version-%release
Provides: dispcalGUI = %version-%release

%add_python3_req_skip pywintypes win32comext.shell win32api win32com.shell win32con win32gui win32process winerror winreg comtypes comtypes.client comtypes.gen.TaskbarLib
%add_python3_req_skip distutils.filelist distutils.util py2exe

# internal
%add_python3_req_skip demjson_compat

#  displaycal: Требует: argyllcms но пакет не может быть установлен
#              Требует: python3(comtypes.client) (< 0) но пакет не может быть установлен
#              Требует: python3(comtypes.gen.TaskbarLib) (< 0) но пакет не может быть установлен
#              Требует: python3(demjson_compat) (< 0) но пакет не может быть установлен


%description
A graphical user interface for the Argyll CMS display calibration utilities.

#--------------------------------------------------------------------

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1

# hack to force creating dist/net.displaycal... (missed due pyproject)
subst "s|create_appdata = |create_appdata = True or |" setup.py

%build
%pyproject_build

%install
%pyproject_install
mkdir -p %buildroot%_sysconfdir/xdg/autostart/
# TODO: fix install to homedir
# /usr/lib64/python3/site-packages/etc/xdg/autostart/z-displaycal-apply-profiles.desktop
mv -v %buildroot%python3_sitelibdir/etc/xdg/autostart/z-displaycal-apply-profiles.desktop %buildroot%_sysconfdir/xdg/autostart/
rm -v %buildroot%python3_sitelibdir/%up_name/{setup.py,postinstall.py}
# only used by py2exe to build standalone Windows executable programs but
# requires setuptools which is not supposed to be installed for runtime
# see for details: misc/build_windows_installer.cmd
rm -v %buildroot%python3_sitelibdir/%up_name/freeze.py
# it's not used for Linux anyway
rm -v %buildroot%python3_sitelibdir/%up_name/cacert.pem

%files
%_sysconfdir/xdg/autostart/z-displaycal-apply-profiles.desktop
%_bindir/%name
%_bindir/%name-*
%_datadir/%up_name/
%_iconsdir/hicolor/*/apps/%{name}*.png
%_desktopdir/*.desktop
%_metainfodir/net.displaycal.%up_name.appdata.xml
%python3_sitelibdir/%up_name/
%python3_sitelibdir/%{pyproject_distinfo %name}/
%_man1dir/*
%exclude %_docdir/%up_name-%version/
# https://github.com/eoyilmaz/displaycal-py3/issues/500
%exclude %python3_sitelibdir/%up_name/dev/
%exclude %python3_sitelibdir/misc/
%exclude %python3_sitelibdir/util/
%exclude %python3_sitelibdir/tests/
%exclude %_datadir/doc-base/

%changelog
