
%define _unpackaged_files_terminate_build 1
%define _customdocdir %_docdir/%name

Name: dillo
Version: 3.2.0
Release: alt2

Summary: a small FLTK-based web browser
License: GPL-3.0-or-later
Group: Networking/WWW
Url: https://dillo-browser.github.io
VCS: https://github.com/dillo-browser/dillo.git

Source0: %name-%version.tar
Source1: %name-16.png
Source2: %name-32.png
Patch: dillo-3.2.0-alt-russian-desktop.patch

BuildRequires: fontconfig-devel
BuildRequires: gcc-c++
BuildRequires: libfltk-devel
BuildRequires: libjpeg-devel
BuildRequires: libpng-devel
BuildRequires: libssl-devel
BuildRequires: libwebp-devel
BuildRequires: libXcursor-devel
BuildRequires: libXfixes-devel
BuildRequires: libXft-devel
BuildRequires: libXinerama-devel
BuildRequires: perl-libnet

%description
Dillo 3 is a graphical multi-platform web browser known for its
speed and small footprint. It is based on FLTK 1.3,
the Fast and Light Toolkit (FLTK).

Dillo aims to be small in resources, stable, developer-friendly,
usable, very fast, and extensible.

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
  --enable-ipv6 \
  --enable-tls \
  --with-ca-certs-file=%_datadir/ca-certificates/ca-bundle.crt \
  #

%make_build

%install
%makeinstall

mkdir -p -- %buildroot%_sysconfdir/dillo
mv -t  %buildroot/%_sysconfdir/dillo/ -- \
  %buildroot%_sysconfdir/*rc             \
  %buildroot%_sysconfdir/hsts_preload

install -Dm0644 -- %SOURCE1 %buildroot%_miconsdir/dillo.png
install -Dm0644 -- %SOURCE2 %buildroot%_niconsdir/dillo.png

%find_lang %name

%files -f %name.lang
%doc AUTHORS ChangeLog README
%doc %_customdocdir/user_help.html

%dir %_sysconfdir/dillo
%config(noreplace) %_sysconfdir/dillo/domainrc
%config(noreplace) %_sysconfdir/dillo/keysrc
%config(noreplace) %_sysconfdir/dillo/dpidrc
%config(noreplace) %_sysconfdir/dillo/dillorc
%config(noreplace) %_sysconfdir/dillo/hsts_preload

%_bindir/dillo
%_bindir/dillo-install-hyphenation
%_bindir/dpid
%_bindir/dpidc
%_libdir/dillo

%_desktopdir/dillo.desktop
%_iconsdir/hicolor/*/*/dillo.png
%_man1dir/dillo.1*

%changelog
