%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
Name: dictd
Version: 1.13.3
Release: alt1
Epoch: 1

Url: http://www.dict.org/
License: GPLv2

Source: %name-%version.tar.gz
Source2: dictd.init
Source3: dictdconfig
Source4: dictd.conf
Source5: dict.conf
Source6: dictd-control
Source7: dictd-README.ALT-ru_RU.UTF-8
Source8: dictd.service
Source9: dictd.filetrigger

# -------  dictd package description ----- #

Summary: dict server that serves dictionaries for clients
Summary(ru_RU.UTF-8): Сервер словарей, обслуживающий клиентов по протоколу dict
Group: System/Servers

# Automatically added by buildreq on Thu Sep 22 2005
BuildRequires: flex groff-base texlive-collection-basic texlive-collection-basic texlive-collection-latexrecommended transfig zlib-devel
BuildRequires: libmaa-devel

%description
This package contains dictionary server that supports DICT clients
(Dictionary Server Protocol). There are many console and graphical DICT
clients. Here are some of them that are supported by ALT Linux
distributions:
* dict
* kdict
* gdict

%description -l ru_RU.UTF-8 -n dictd
Данный пакет содержит сервер словарей, поддерживающий DICT-клиентов
(Dictionary Server Protocol -- протокол сервера словарей). Существует много
консольных и графических DICT-клиентов. Вот некоторые из входящих в дистрибутивы
ALT Linux:
* dict
* kdict
* gdict

# -------- dict-tools description ------- #

%package -n dict-tools
# Name: dictd
Summary: tools for making dictionary files for dictd server
Summary(ru_RU.UTF-8): Средства для создания словарных файлов для сервера dictd
Group: Development/Other

%description -n dict-tools
This package contains various tools for creating and working with
dictionaries in dictd server format:
* dictzip(1) is a compression program which creates compressed files
  in the gzip format (see RFC 1952).
* dictfmt is program for making binary dictionaries from plain format

%description -n dict-tools -l ru_RU.UTF-8
Этот пакет содержит различные средства для создания словарей в формате
dictd и работы с ними:
* dictzip -- программа для сжатия словарей (см. RFC 1952).
* dictfmt -- программа для создание словарей в формате DICT из текстовых файлов.

# -------- dict-devel description ------- #
%package -n dict-devel
Summary: Headers for dictd server plugins
Summary(ru_RU.UTF-8): Заголовочные файлы для сборки модулей к серверу dictd
Group: Development/Other

%description -n dict-devel
This package contains header files for dictd server plugins

%description -n dict-devel -l ru_RU.UTF-8
Данный пакет содержит заголовочные файлы для сборки модулей к серверу dictd

# ------- dict description ------ #
%package -n dict
# Name: dictd
Summary: dict client
Summary(ru_RU.UTF-8): Консольный клиент для dictd-сервера
Group: Text tools

%description -n dict
This package contains console client for DICT server. It is light and
easy to use.

%description -n dict -l ru_RU.UTF-8
Данный пакет содержит консольный клиент для DICT-сервера. Он лёгок и
прост в работе.

# ------- colorit description ------ #
%package -n colorit
# Name: dictd
Summary: script for colorizing plain text sent to terminal emulator.
Group: Text tools

%description -n colorit
colorit is a script for markuping text input and sending a result to
pager ('less -r' by default) or stdout.  Markuping rules are described
in a configuration file which is filtered by preprocessor (the default
is m4). This script can be used for colorizing the text by ANSI escape
sequences, or making a simple text conversions and may be used as a
pager instead of less by dict(1) or other programs, e.g., cc(1),
make(1), or diff(1) output can easily be colorized and viewed.

# ------- dict_lookup ------ #
%package -n dict_lookup
# Name: dictd
Summary: Dictionary Protocol Client for X11
Group: Text tools

%description -n dict_lookup
dict_lookup reads X selection, then open
terminal emulator and run dict client in it allowing user to view
content using pager.  It makes sense to configure launching
dict_lookup on a keyboard shortcut in the window manager.

# --------------- real part ----------------  #
%prep
%setup
cp %SOURCE7 README.ALT-ru_RU.UTF-8

%build
#%autoreconf
%configure --without-local-zlib
# FIXME: non-SMP-safe build as of 1.12.1
#make_build
make
%make -C doc/ rfc.txt

%install
mkdir -p %buildroot%_bindir
mkdir -p %buildroot%_man1dir
mkdir -p %buildroot%_sbindir
mkdir -p %buildroot%_initdir
%makeinstall man1_prefix=%buildroot%_man1dir man8_prefix=%buildroot%_man8dir
install -p -m644 dict.1 %buildroot%_man1dir

install -p -m755 %SOURCE2 %buildroot%_initdir/%name
install -p -m755 -D %SOURCE3 %buildroot%_sbindir/dictdconfig
install -p -m644 -D %SOURCE4 %buildroot%_sysconfdir/%name.conf
install -p -m644 -D %SOURCE5 %buildroot%_sysconfdir/dict.conf
mkdir -p %buildroot%_localstatedir/%name
mkdir -p %buildroot%_datadir/%name

# Dictionary default order
cat >%buildroot%_sysconfdir/dictd.order <<EOF
# You can arrange dictionaries' priority here
wn
engcom
foldoc
vera
web1913
jargon
elements
easton
hitchcock
gazetteer
%_datadir/%name/
EOF

mkdir -p %buildroot%_sysconfdir/sysconfig/
# Default configuration
cat >%buildroot%_sysconfdir/sysconfig/dictd <<EOF
# See %_sysconfdir/dictd.conf for additional restrictions
LISTENTO="--listen-to 127.0.0.1"
EXTRAOPTIONS="--locale ru_RU.UTF-8 \$LISTENTO"
EOF

install -D -m 755 %SOURCE6 %buildroot%_controldir/dictd
install -D -m 644 %SOURCE8 %buildroot%_unitdir/dictd.service
install -D -m 755 %SOURCE9 %buildroot%_rpmlibdir/dictd.filetrigger

%pre
%_sbindir/groupadd -r dictd &>/dev/null ||:
%_sbindir/useradd -r -n -M -g dictd -d %_localstatedir/%name -s /dev/null dictd  &>/dev/null ||:

%post
if [ "$1" = "1" ]; then
	%_sbindir/dictdconfig -w
fi
%post_service %name

%preun
%preun_service %name

%files
%doc doc/rfc.txt README README.ALT-ru_RU.UTF-8
%config(noreplace) %_sysconfdir/dictd.conf
%config(noreplace) %_sysconfdir/dictd.order
%config(noreplace) %_sysconfdir/sysconfig/dictd
%_controldir/dictd
%_sbindir/dictd
%_sbindir/dictdconfig
%_man8dir/*
%_initdir/%name
%_datadir/%name
%_localstatedir/%name
%_unitdir/dictd.service
%_rpmlibdir/dictd.filetrigger

%files -n dict-tools
%_bindir/dictfmt
%_bindir/dictunformat
%_bindir/dictzip
%_bindir/dictfmt_index2suffix
%_bindir/dictfmt_index2word
%_man1dir/dictfmt.1*
%_man1dir/dictunformat.1*
%_man1dir/dictzip.1*
%_man1dir/dictfmt_index2suffix.1*
%_man1dir/dictfmt_index2word.1*

%files -n dict-devel
%_includedir/dictdplugin.h
%_bindir/dictdplugin-config

%files -n dict
%doc README
%config(noreplace) %_sysconfdir/dict.conf
%exclude %_bindir/dictl
%exclude %_man1dir/dictl.*
%_bindir/dict
%_man1dir/dict.1*

%files -n dict_lookup
%_bindir/dict_lookup
%_man1dir/dict_lookup.1*

%files -n colorit
%_bindir/colorit
%_man1dir/colorit.1*

%changelog
