%def_disable snapshot

%define ver_major 43
%define beta %nil
%define api_ver_major 3
%define api_ver 3.0
%define xdg_name org.gnome.Devhelp

%def_enable gtk_doc
%def_enable plugin_gedit

Name: devhelp
Version: %ver_major.0
Release: alt1%beta

Summary: Developer's help program
Group: Development/Other
License: GPL-3.0
Url: https://wiki.gnome.org/Apps/Devhelp

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%add_python3_path %_libdir/gedit/plugins

%define gtk_ver 3.22.0
%define webkit_api_ver 4.1
%define webkit_ver 2.26
%define glib_ver 2.64
%define amtk_ver 5.0

Requires: lib%name = %version-%release

BuildRequires(pre): rpm-macros-meson rpm-build-gnome rpm-build-python3
BuildRequires: meson gtk-doc yelp-tools /usr/bin/appstream-util
BuildRequires: pkgconfig(gtk+-3.0) >= %gtk_ver
BuildRequires: pkgconfig(webkit2gtk-%webkit_api_ver) >= %webkit_ver
BuildRequires: pkgconfig(gio-2.0) >= %glib_ver
BuildRequires: pkgconfig(amtk-5) >= %amtk_ver
BuildRequires: zlib-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel libwebkit2gtk%webkit_api_ver-gir-devel
BuildRequires: gsettings-desktop-schemas-devel
%{?_enable_gtk_doc:BuildRequires: gi-docgen}

%description
A developers help program.

%package -n lib%name
Summary: Devhelp widgets library
Group: System/Libraries

%description -n lib%name
This package provides shared library required for Devhelp to work.

%package -n lib%name-devel
Summary: Devhelp widgets headers
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package provides files required to develop programs that use
Devhelp widgets.

%package -n lib%name-gir
Summary: GObject introspection data for the Devhelp library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
This package provides GObject introspection data for the Devhelp
library.

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Devhelp library
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-gir-devel
This package provides GObject introspection devel data for the Devhelp
library.

%package -n lib%name-devel-doc
Summary: Development documentation for Devhelp library
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%name-devel < %version

%description -n lib%name-devel-doc
This package provides development documentation for the Devhelp library.

%package -n gedit-plugin-%name
Summary: DevHelp integration into GEdit
Group: Development/Other
Requires: %name = %version-%release

%description -n gedit-plugin-%name
This plugin for GEdit enables using DevHelp from inside the editor.

%define _devhelpdir %_datadir/%name
%define  gedit_pluginsdir %_libdir/gedit/plugins

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{?_enable_plugin_gedit:-Dplugin_gedit=true} \
    %{?_enable_gtk_doc:-Dgtk_doc=true}
%nil
%meson_build

%install
%meson_install

# Create some directories in %name hierarchy
mkdir -p %buildroot%_devhelpdir/{specs,books}

%find_lang --with-gnome %name

%check
%__meson_test

%files -f %name.lang
%_bindir/*
%dir %_devhelpdir
%_devhelpdir/*
%_desktopdir/%{xdg_name}*.desktop
%_iconsdir/hicolor/*/*/*.svg
%_datadir/dbus-1/services/%{xdg_name}*.service
%_datadir/glib-2.0/schemas/org.gnome.devhelp.gschema.xml
%_man1dir/%name.1.*
%_datadir/metainfo/%{xdg_name}*.appdata.xml
%doc NEWS README*

%files -n lib%name
%_libdir/*.so.*
%_datadir/glib-2.0/schemas/org.gnome.libdevhelp-3.gschema.xml

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/lib%name-*.pc

%files -n lib%name-gir
%_typelibdir/Devhelp-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/Devhelp-%api_ver.gir

%if_enabled gtk_doc
%files -n lib%name-devel-doc
#%_datadir/gtk-doc/html/%name-*/
%_datadir/doc/%name-%api_ver_major
%endif

%{?_enable_plugin_gedit:
%files -n gedit-plugin-%name
%gedit_pluginsdir/*}

%changelog
