Name: dejagnu
Version: 1.6.2
Release: alt2
Epoch: 1

Summary: A front end for testing other programs
License: GPLv3+
Group: Development/Other
Url: https://www.gnu.org/software/%name/
BuildArch: noarch

# git://git.altlinux.org/gears/d/dejagnu.git
Source: %name-%version-%release.tar

Requires: expect /dev/pts
BuildRequires: expect gcc-c++ makeinfo
%{?!_without_check:%{?!_disable_check:BuildRequires: /dev/pts}}

%description
DejaGnu is an Expect/Tcl based framework for testing other programs.
DejaGnu has several purposes: to make it easy to write tests for any
program; to allow you to write tests which will be portable to any
host or target where a program must be tested; and to standardize the
output format of all tests (making it easier to integrate the testing
into software development).

%prep
%setup -n %name-%version-%release

%build
%configure
%make_build MAKEINFOFLAGS=--no-split

%install
%makeinstall_std
ln -rsnf %buildroot/usr/share/gnu-config/config.guess \
	%buildroot%_datadir/%name/libexec/

%check
[ -w /dev/ptmx ] || exit 0
%make_build -k check

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%files
%_bindir/*
%_datadir/%name
%_includedir/*
%_infodir/*
%_mandir/man?/*
%doc NEWS README AUTHORS ChangeLog

%changelog
