%def_without clang

%define repo dmusic
%define dmusic_ver 1

Name: deepin-music
Version: 7.0.48
Release: alt1

Summary: Awesome music player with brilliant and tweakful UI Deepin-UI based

License: GPL-3.0+
Group: Sound
Url: https://github.com/linuxdeepin/deepin-music
VCS: https://github.com/linuxdeepin/deepin-music

# Source-url: https://github.com/linuxdeepin/deepin-music/archive/%version/%name-%version.tar.gz
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-ninja rpm-macros-dqt6
# Automatically added by buildreq on Wed Aug 13 2025
# optimized out: cmake cmake-modules dqt6-base-devel dqt6-tools gcc-c++ glibc-kernheaders-generic glibc-kernheaders-x86 icu-utils libavcodec-devel libavutil-devel libcairo-gobject libdouble-conversion3 libdqt6-core libdqt6-core5compat libdqt6-dbus libdqt6-gui libdqt6-multimedia libdqt6-network libdqt6-opengl libdqt6-printsupport libdqt6-qml libdqt6-qmlmeta libdqt6-qmlmodels libdqt6-qmlworkerscript libdqt6-quick libdqt6-sql libdqt6-waylandclient libdqt6-widgets libdqt6-xml libdtk6core-devel libdtk6gui-devel libdtk6log-devel libgdk-pixbuf libglvnd-devel libgpg-error libmpris-dqt6-1 libopencore-amrnb0 libopencore-amrwb0 libp11-kit librabbitmq-c4 libsasl2-3 libssl-devel libstartup-notification libstdc++-devel libwayland-client libwayland-cursor libx265-215 libxkbcommon-devel ninja-build ocl-icd pkg-config python3 python3-base samba-common-libs sh5 vulkan-headers zlib-devel
BuildRequires: dqt6-5compat-devel dqt6-declarative-devel dqt6-multimedia-devel dqt6-sql-interbase dqt6-sql-mysql dqt6-sql-odbc dqt6-sql-postgresql dqt6-tools-devel libSDL2-devel libavformat-devel libdtk6declarative-devel libdtk6widget-devel libicu-devel libmpris-dqt6-devel libvlc-devel taglib-devel

%if_with clang
BuildRequires: clang-devel
BuildRequires: lld-devel
%else
BuildRequires: gcc-c++
%endif

Requires: vlc-mini ffmpeg dtk6declarative

%description
%summary.

%package -n lib%repo%dmusic_ver
Summary: %repo library for %name
Group: System/Libraries
Provides: lib%name = %version
Obsoletes: lib%name < %version

%description -n lib%repo%dmusic_ver
The package provides %repo library for %name.

%package -n lib%repo-devel
Summary: Static libraries for %name
Group: Development/C++
Provides: %name-devel = %version
Obsoletes: %name-devel < %version

%description -n lib%repo-devel
The package provides development files for %repo library.

%prep
%setup
%patch -p1

%build
%if_with clang
%define optflags_lto -flto=thin
export CC=clang
export CXX=clang++
export LDFLAGS="-fuse-ld=lld $LDFLAGS"
%else
%define optflags_lto %nil
%endif
%DQ6build \
  -DVERSION=%version \
#

%install
%DQ6install
%find_lang --with-qt %name

%files -f %name.lang
%doc debian/changelog LICENSE README.md
%_bindir/%name
# package translations outside %%find_lang
%dir %_datadir/%name/
%dir %_datadir/%name/translations/
%_datadir/%name/translations/deepin-music.qm
%_datadir/%name/translations/deepin-music_ky@Arab.qm
# ---
%_desktopdir/%name.desktop
%_iconsdir/hicolor/scalable/apps/%name.svg
%dir %_datadir/dsg/
%dir %_datadir/dsg/configs/
%dir %_datadir/dsg/configs/deepin-music/
%_datadir/dsg/configs/deepin-music/org.deepin.music.json
%dir %_datadir/deepin-manual/
%dir %_datadir/deepin-manual/manual-assets/
%dir %_datadir/deepin-manual/manual-assets/application/
%dir %_datadir/deepin-manual/manual-assets/application/%name/
%_datadir/deepin-manual/manual-assets/application/%name/music/

%files -n lib%repo%dmusic_ver
%_libdir/lib%repo.so.%{dmusic_ver}.0*

%files -n lib%repo-devel
%_libdir/lib%repo.so

%changelog
