%def_with clang

Name: deepin-movie
Version: 6.5.26
Release: alt1

Summary: Deepin movie is Deepin Desktop Environment Movie Player

License: GPL-3.0+ and CC0-1.0 and CC-BY-4.0
Group: Video
Url: https://github.com/linuxdeepin/deepin-movie-reborn
Vcs: https://github.com/linuxdeepin/deepin-movie-reborn

Packager: Leontiy Volodin <lvol@altlinux.org>

Source: %url/archive/%version/%name-reborn-%version.tar
Patch0: %name-%version-%release.patch
Patch1: %name-6.5.6-alt-cxx-flags.patch
Patch2: %name-6.5.6-alt-pkgconfig-find-requires.patch
Patch3: %name-6.5.22-alt-overlinked-libs.patch

#Requires: libdmr libdvdnav libgsettings-qt
# direct dependency because dmr controls mpv via libmpv calls
Requires: libmpv2
Requires: libdqt6-gui = %_dqt6_version

BuildRequires(pre): rpm-build-ninja rpm-macros-dqt6
# Automatically added by buildreq on Mon Mar 10 2025
# optimized out: alt-os-release clang19.1 clang19.1-support cmake cmake-modules dqt6-base-devel dqt6-tools glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 gstreamer1.0-devel libX11-devel libavcodec-devel libavformat-devel libavutil-devel libclang-cpp19 libdouble-conversion3 libdqt6-concurrent libdqt6-core libdqt6-dbus libdqt6-gui libdqt6-multimedia libdqt6-multimediawidgets libdqt6-network libdqt6-opengl libdqt6-openglwidgets libdqt6-printsupport libdqt6-qml libdqt6-sql libdqt6-svg libdqt6-svgwidgets libdqt6-waylandclient libdqt6-widgets libdqt6-xml libdtk6core-devel libdtk6gui-devel libdtk6log-devel libdvdread-devel libglvnd-devel libgpg-error libgsettings-qt1 libmpris-dqt6-1 libp11-kit libsasl2-3 libssl-devel libstartup-notification libstdc++-devel libva-devel libwayland-client libwayland-cursor libxcb-devel libxkbcommon-devel lld19.1 llvm-common llvm19.1-libs ninja-build pkg-config python3 python3-base sh5 vulkan-headers xorg-proto-devel
BuildRequires: dqt6-multimedia-devel dqt6-svg-devel dqt6-tools-devel gst-plugins1.0-devel libXtst-devel dtk6-common-devel libdtk6widget-devel libdvdnav-devel libffmpegthumbnailer-devel libmpris-dqt6-devel libmpv-devel libxcbutil-devel
BuildRequires: dqt6-sql-interbase dqt6-sql-mysql dqt6-sql-odbc dqt6-sql-postgresql

%if_with clang
BuildRequires: clang-devel lld-devel
%else
BuildRequires: gcc-c++
%endif

%description
%summary.

%package -n libdmr
Summary: Library for %name
Group: System/Libraries
Requires: libdqt6-gui = %_dqt6_version

%description -n libdmr
This package provides Library for %name.

%package -n libdmr-devel
Summary: Development files for libdmr
Group: Development/Other

%description -n libdmr-devel
This package provides development files for libdmr.

%prep
%setup -n %name-reborn-%version
%patch0 -p1
%if_with clang
# build: use system opt flags.
# The package isn't built with the patch using gcc.
%patch1 -p1
%endif
%patch2 -p1
%patch3 -p2
# ffmpeg7
sed -i 's|->channels|->ch_layout.nb_channels|g' \
  src/libdmr/playlist_model.{cpp,h} \
  src/libdmr/gstutils.{cpp,h} \
  src/widgets/movieinfo_dialog.cpp

%build
%if_with clang
%define optflags_lto -flto=thin
export CC=clang
export CXX=clang++
export LDFLAGS="-fuse-ld=lld $LDFLAGS"
%else
export CC=gcc
export CXX=g++
%endif
%DQ6build \
    -DCMAKE_INSTALL_PREFIX=%_prefix \
    -DCMAKE_INSTALL_LIBDIR=%_libdir \
    -DVERSION=%version

%install
%DQ6install
%find_lang %name

%files -f %name.lang
%doc debian/changelog HACKING.md LICENSE LICENSES README.md
%_bindir/%name
%_datadir/%name/
%_desktopdir/%name.desktop
%_datadir/dbus-1/services/com.deepin.movie.service
%_datadir/glib-2.0/schemas/com.deepin.deepin-movie.gschema.xml
%_iconsdir/hicolor/scalable/apps/%name.svg
%dir %_datadir/deepin-manual/
%dir %_datadir/deepin-manual/manual-assets/
%dir %_datadir/deepin-manual/manual-assets/application/
%dir %_datadir/deepin-manual/manual-assets/application/%name/
%_datadir/deepin-manual/manual-assets/application/%name/movie/
%dir %_datadir/dsg/
%dir %_datadir/dsg/configs/
%dir %_datadir/dsg/configs/org.deepin.movie/
%_datadir/dsg/configs/org.deepin.movie/org.deepin.movie.minimode.json

%files -n libdmr
%_libdir/libdmr.so.0.1*

%files -n libdmr-devel
%_libdir/libdmr.so
%dir %_includedir/libdmr/
%_includedir/libdmr/*.h
%_pkgconfigdir/libdmr.pc

%changelog
