%define repo dde-launchpad

%def_disable clang

Name: deepin-launchpad
Version: 2.0.16
Release: alt1

Summary: Launcher for DDE - next generation

License: GPL-3.0-or-later
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/dde-launchpad
Vcs: https://github.com/linuxdeepin/dde-launchpad

Provides: %repo = %EVR
Conflicts: deepin-launcher
Obsoletes: deepin-launcher

# Source-url: %url/archive/%version/%repo-%version.tar.gz
Source: %repo-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-ninja rpm-macros-dqt6
%if_enabled clang
BuildRequires(pre): clang-devel
%else
BuildRequires(pre): gcc-c++
%endif
BuildRequires: cmake dtk6-common-devel libappstream-qt6-devel libdtk6gui-devel libgio-devel dqt6-declarative-devel dqt6-svg-devel dqt6-tools-devel libsystemd-devel dqt6-wayland-devel libwayland-egl-devel libwayland-server-devel libdde-shell-devel deepin-shell
BuildRequires: libdqt6-qmlcompiler libdqt6-quickcontrols2

%description
%summary.

%package -n liblaunchpadcommon
Summary: liblaunchpadcommon library for %name
Group: System/Libraries
Requires: libdqt6-core = %_dqt6_version libdqt6-gui = %_dqt6_version libdqt6-waylandclient = %_dqt6_version

%description -n liblaunchpadcommon
This package provides liblaunchpadcommon library for %name.

%prep
%setup -n %repo-%version
%autopatch -p1
sed -i 's|AppStreamQt|AppStreamQt6|' \
  CMakeLists.txt \
  desktopintegration.cpp

%build
%if_enabled clang
export CC="clang"
export CXX="clang++"
export LDFLAGS="-fuse-ld=lld $LDFLAGS"
%endif
%DQ6build

%install
%DQ6install
%find_lang --with-qt %repo

%files -f %repo.lang
%doc README.md debian/changelog
%dir %_datadir/dde-shell/
%_datadir/dde-shell/org.deepin.ds.dock.launcherapplet/
%_datadir/metainfo/org.deepin.dde.shell.launchpad.appdata.xml
%dir %_datadir/dsg/
%dir %_datadir/dsg/configs/
%dir %_datadir/dsg/configs/dde-launchpad/
%_datadir/dsg/configs/dde-launchpad/org.deepin.dde.launchpad.appsmodel.json
%dir %_datadir/dsg/configs/org.deepin.dde.shell/
%_datadir/dsg/configs/org.deepin.dde.shell/org.deepin.ds.launchpad.json
%dir %_libdir/dde-shell/
%_libdir/dde-shell/org.deepin.ds.dock.launcherapplet.so

%files -n liblaunchpadcommon
%_libdir/launchpadcommon.so

%changelog
