%define sover 6

%def_disable clang

%define _cmake__builddir BUILD
%define repo dde-control-center

Name: deepin-control-center
Version: 6.1.47
Release: alt1

Summary: New control center for Linux Deepin

License: GPL-3.0-or-later and MIT
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/dde-control-center
Vcs: https://github.com/linuxdeepin/dde-control-center

Source: %url/archive/%version/%repo-%version.tar.gz
Patch0: %name-%version-%release.patch
Patch1: deepin-control-center-6.1.4-alt-qch.patch
Patch2: deepin-control-center-6.1.40-alt-fixes-underlinked-libs.patch

#FAILED: src/plugin-mouse/CMakeFiles/mouse.dir/mouse_autogen/OYYSJO5W5K/qrc_mouse.cpp.o
#virtual memory exhausted: Cannot allocate memory
ExcludeArch: i586

BuildRequires(pre): rpm-macros-dqt6 patchelf
BuildRequires: cmake deepin-gettext-tools doxygen libdeepin-pw-check-devel dtk6-common-devel libdtk6widget-devel libpolkitqt6-qt6-devel dqt6-declarative-devel dqt6-tools-devel dqt6-multimedia-devel dqt6-svg-devel dqt6-wayland-devel libdqt6-qmlcompiler libgtest-devel libsystemd-devel treeland-protocols libwayland-egl-devel libdareader-devel libdde-shell-devel deepin-shell
%if_enabled clang
BuildRequires: clang-devel lld-devel
%else
BuildRequires: gcc-c++
%endif

%description
New control center for Linux Deepin.

%package -n lib%repo%sover
Summary: Library for %name
Group: System/Libraries

%description -n lib%repo%sover
This package provides library for %name.

%package -n lib%repo-devel
Summary: %summary
Group: Development/C++
Provides: %name-devel
Obsoletes: %name-devel

%description -n lib%repo-devel
This package provides development files for %name.

%prep
%setup -n %repo-%version
%autopatch -p1
# We do not use dpkg and deepinid.
sed -e '/add_subdirectory(src\/plugin-privacy)/d;' \
    -e '/add_subdirectory(src\/plugin-deepinid)/d;' \
    -i CMakeLists.txt

%build
export CPLUS_INCLUDE_PATH=%_dqt6_headerdir/QtXkbCommonSupport/%{_dqt6_version}:$CPLUS_INCLUDE_PATH
export SYSTYPE=Desktop
%if_enabled clang
export CC="clang"
export CXX="clang++"
export LDFLAGS="-fuse-ld=lld $LDFLAGS"
%endif
%DQ6build \
  -DCMAKE_INSTALL_LIBDIR=%_libdir \
  -DDCC_PLUGINS_INSTALL_DIR=%_lib/dde-control-center/plugins_v1.0 \
  -DDISABLE_AUTHENTICATION=ON \
  -DDISABLE_UPDATE=ON \
  -DDISABLE_SOUND_ADVANCED=ON \
#

%install
%DQ6install

# cleanup broken rpaths in elfs
patchelf %buildroot%_libdir/dde-control-center/plugins_v1.0/dock/dock.so --shrink-rpath --allowed-rpath-prefixes %_dqt6_libdir
patchelf %buildroot%_libdir/dde-control-center/plugins_v1.0/display/display.so --shrink-rpath --allowed-rpath-prefixes %_dqt6_libdir
patchelf %buildroot%_libdir/dde-control-center/plugins_v1.0/notification/notification.so --shrink-rpath --allowed-rpath-prefixes %_dqt6_libdir
patchelf %buildroot%_libdir/dde-control-center/plugins_v1.0/blueTooth/blueTooth.so --shrink-rpath --allowed-rpath-prefixes %_dqt6_libdir
patchelf %buildroot%_libdir/dde-control-center/plugins_v1.0/wacom/wacom.so --shrink-rpath --allowed-rpath-prefixes %_dqt6_libdir
patchelf %buildroot%_libdir/dde-control-center/plugins_v1.0/datetime/datetime.so --shrink-rpath --allowed-rpath-prefixes %_dqt6_libdir
patchelf %buildroot%_libdir/dde-control-center/plugins_v1.0/touchscreen/touchscreen.so --shrink-rpath --allowed-rpath-prefixes %_dqt6_libdir
patchelf %buildroot%_libdir/dde-control-center/plugins_v1.0/commonInfo/commonInfo.so --shrink-rpath --allowed-rpath-prefixes %_dqt6_libdir
patchelf %buildroot%_libdir/dde-control-center/plugins_v1.0/systemInfo/systemInfo.so --shrink-rpath --allowed-rpath-prefixes %_dqt6_libdir
patchelf %buildroot%_libdir/dde-control-center/plugins_v1.0/keyboard/keyboard.so --shrink-rpath --allowed-rpath-prefixes %_dqt6_libdir
patchelf %buildroot%_libdir/dde-control-center/plugins_v1.0/personalization/personalization.so --shrink-rpath --allowed-rpath-prefixes %_dqt6_libdir
patchelf %buildroot%_libdir/dde-control-center/plugins_v1.0/mouse/mouse.so --shrink-rpath --allowed-rpath-prefixes %_dqt6_libdir
patchelf %buildroot%_libdir/dde-control-center/plugins_v1.0/power/power.so --shrink-rpath --allowed-rpath-prefixes %_dqt6_libdir
patchelf %buildroot%_libdir/dde-control-center/plugins_v1.0/defaultapp/defaultapp.so --shrink-rpath --allowed-rpath-prefixes %_dqt6_libdir
patchelf %buildroot%_libdir/dde-control-center/plugins_v1.0/sound/sound.so --shrink-rpath --allowed-rpath-prefixes %_dqt6_libdir
patchelf %buildroot%_libdir/dde-control-center/plugins_v1.0/accounts/accounts.so --shrink-rpath --allowed-rpath-prefixes %_dqt6_libdir
patchelf %buildroot%_libdir/dde-control-center/org/deepin/dcc/libdde-control-center-plugin.so --shrink-rpath --allowed-rpath-prefixes %_dqt6_libdir

# package translations
%find_lang --with-qt %repo

%files -f %repo.lang
%doc LICENSE README.md debian/changelog
%_bindir/%repo
%_desktopdir/org.deepin.dde.control-center.desktop
%_datadir/metainfo/org.deepin.dde.controlcenter.metainfo.xml
%_datadir/dbus-1/services/org.deepin.dde.ControlCenter1.service
%dir %_libdir/%repo/
%_libdir/%repo/*.qml
%_libdir/%repo/plugins_v1.0/
%dir %_libdir/%repo/org/
%dir %_libdir/%repo/org/deepin/
%_libdir/%repo/org/deepin/dcc/
%_libdir/%repo/sidebar.dci
%_libdir/%repo/reddot.dci
%dir %_libdir/dde-grand-search-daemon/
%dir %_libdir/dde-grand-search-daemon/plugins/
%dir %_libdir/dde-grand-search-daemon/plugins/searcher/
%_libdir/dde-grand-search-daemon/plugins/searcher/org.deepin.dde-grand-search.dde-control-center-setting.conf
%dir %_datadir/dsg/
%dir %_datadir/dsg/configs/
%dir %_datadir/dsg/configs/org.deepin.dde.control-center/
%_datadir/dsg/configs/org.deepin.dde.control-center/org.deepin.dde.control-center*.json
%_datadir/dsg/configs/org.deepin.region-format.json
%dir %_datadir/%repo/
%_userunitdir/org.deepin.dde.control-center.service
%dir %_datadir/deepin-debug-config/
%dir %_datadir/deepin-debug-config/deepin-debug-config.d/
%_datadir/deepin-debug-config/deepin-debug-config.d/org.deepin.dde.control-center.json
%dir %_datadir/deepin-log-viewer/
%dir %_datadir/deepin-log-viewer/deepin-log.conf.d/
%_datadir/deepin-log-viewer/deepin-log.conf.d/org.deepin.dde.control-center.json
# package outside find_lang
%dir %_datadir/%repo/translations/
%dir %_datadir/%repo/translations/v1.0/
%_datadir/%repo/translations/v1.0/dde-control-center_ky@Arab.qm

%files -n lib%repo%sover
%_libdir/lib%repo.so.%{sover}*

%files -n lib%repo-devel
%_libdir/lib%repo.so
%dir %_libdir/cmake/DdeControlCenter/
%_libdir/cmake/DdeControlCenter/DdeControlCenter*.cmake
%_includedir/%repo/

%changelog
