%def_disable clang

Name: deepin-calculator
Version: 6.5.27
Release: alt1

Summary: An easy to use calculator for ordinary users

License: GPL-2.0+ and GPL-3.0+
# 3rdparty: GPL-2.0+
# src: GPL-3.0+
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/deepin-calculator
VCS: https://github.com/linuxdeepin/deepin-calculator

# Source-url: https://github.com/linuxdeepin/deepin-calculator/archive/%version/%name-%version.tar.gz
Source: %name-%version.tar
Patch: %name-%version-%release.patch

%if_enabled clang
BuildRequires(pre): clang-devel
%else
BuildRequires(pre): gcc-c++
%endif
BuildRequires(pre): desktop-file-utils
BuildRequires: dqt6-svg-devel dqt6-tools-devel dtk6-common-devel libcups-devel libdtk6widget-devel
Requires: icon-theme-hicolor

%description
%summary.

%prep
%setup
%patch -p1

%build
%if_enabled clang
export CC="clang"
export CXX="clang++"
export AR="llvm-ar"
export NM="llvm-nm"
export READELF="llvm-readelf"
%endif
%DQ6build \
    -DCMAKE_INSTALL_LIBDIR=%_libdir \
    -DVERSION=%version \
#

%install
%DQ6install
%find_lang --with-qt %name

%check
desktop-file-validate %buildroot%_desktopdir/%name.desktop ||:

%files -f %name.lang
%doc README.md
%doc LICENSE
%doc debian/changelog
%_bindir/%name
%_desktopdir/%name.desktop
%_iconsdir/hicolor/scalable/apps/%name.svg
# package outside find_lang
%dir %_datadir/%name/
%dir %_datadir/%name/translations/
%_datadir/%name/translations/%name.qm
# ---
%dir %_datadir/deepin-manual/
%dir %_datadir/deepin-manual/manual-assets/
%dir %_datadir/deepin-manual/manual-assets/application/
%_datadir/deepin-manual/manual-assets/application/%name/

%changelog
