%define goipath github.com/linuxdeepin/dde-api

Name: deepin-api
Version: 6.0.29
Release: alt1

Summary: Golang bingding for dde-daemon

License: GPL-3.0+
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/dde-api
Vcs: https://github.com/linuxdeepin/dde-api

# Source-url: https://github.com/linuxdeepin/dde-api/archive/%version/dde-api-%version.tar.gz
Source0: dde-api-%version.tar
# go mod vendor
Source1: vendor.tar
Patch: %name-%version-%release.patch

#Requires: deepin-desktop-base rfkill
#Requires(pre): shadow-utils dbus-tools

BuildRequires(pre): rpm-build-golang rpm-build-python3
BuildRequires: libgtk+3-devel glib2-devel libgio-devel libgdk-pixbuf-xlib-devel libXcursor-devel libpoppler-glib-devel librsvg-devel libXfixes-devel libalsa-devel libpulseaudio-devel libgudev-devel libXi-devel deepin-gettext-tools
BuildRequires: /proc

%description
%summary.

%package -n golang-%name-devel
Summary: %summary
Group: Graphical desktop/Other
AutoReq: no
# BuildArch: noarch

%description -n golang-%name-devel
%summary.

This package contains library source intended for
building other packages which use import path with
%goipath prefix.

%prep
%setup -n dde-api-%version -a1
%autopatch -p1
sed -i 's|/usr/sbin/locale-gen|locale-gen|' \
  locale-helper/main.go
sed -i 's|/usr/bin/true|/bin/true|' \
  misc/systemd/system/deepin-shutdown-sound.service

%build
export GOFLAGS="-mod=vendor"
%make

%install
export GOPATH="%go_path"
%makeinstall_std SYSTEMD_SERVICE_DIR="%_unitdir" -i

%files
%doc README.md LICENSE debian/changelog
%_bindir/*
%dir %_libexecdir/deepin-api/
%_libexecdir/deepin-api/*
%_iconsdir/hicolor/??x??/actions/*
%_iconsdir/hicolor/???x???/actions/*
%_iconsdir/hicolor/scalable/actions/*
%_datadir/dbus-1/*
%_datadir/polkit-1/*
%_unitdir/*.service
%_sharedstatedir/polkit-1/*
%dir %_datadir/dde-api/
%dir %_datadir/dde-api/data/
%_datadir/dde-api/data/*

%files -n golang-%name-devel
%go_path/src/%goipath

%changelog
