%def_disable snapshot

%define _unpackaged_files_terminate_build 1
%define ver_major 49
%define beta %nil
%define xdg_name ca.desrt.dconf-editor

Name: dconf-editor
Version: %ver_major.0
Release: alt1%beta

Summary: dconf confuguration editor
Group: Graphical desktop/GNOME
License: GPL-3.0-or-later
Url: https://wiki.gnome.org/Projects/dconf

Vcs: https://gitlab.gnome.org/GNOME/dconf-editor.git

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.56
%define dconf_ver 0.26.1
%define gtk_ver 3.22.27
%define handy_ver 1.6
%define vala_ver 0.40

Requires: dconf >= %dconf_ver

BuildRequires(pre): rpm-macros-meson gnome-common
BuildRequires: meson vala-tools >= %vala_ver
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libdconf-devel >= %dconf_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver
BuildRequires: libxml2-devel rpm-build-gnome
BuildRequires: libappstream-glib-devel yelp-tools
BuildRequires: libdconf-vala

%description
dconf is a low-level configuration system. Its main purpose is to
provide a backend to GSettings API in Glib for storing and retrieving
application settings.

This package provides graphical dconf configuration editor.


%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install

%find_lang --with-gnome --output=%name.lang %name dconf

%files -f %name.lang
%_bindir/%name
%_datadir/applications/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_iconsdir/hicolor/*/*/*.*
%_man1dir/%name.1.*
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.metainfo.xml
# "nosort" bad option?
%_datadir/bash-completion/completions/%name
%doc README*

%changelog
