%def_disable snapshot

%define ver_major 0.49
%def_disable introspection
%def_enable gtk_doc
%def_enable man
%def_enable bash_completion
%def_enable vala
%def_enable check

%define gvdb_ver 4758f6fb

Name: dconf
Version: %ver_major.0
Release: alt1

Summary: A simple configuration system
Group: System/Servers
License: LGPL-2.1-or-later
Url: https://wiki.gnome.org/Projects/dconf

Vcs: https://gitlab.gnome.org/GNOME/dconf.git

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: https://download.gnome.org/sources/dconf/%ver_major/%name-%version.tar.xz
%endif
%{?_enable_snapshot:Source1: gvdb-%gvdb_ver.tar}
Source2: update-dconf-database.filetrigger

Provides: %_rpmlibdir/update-dconf-database.filetrigger

Requires: lib%name = %EVR dbus
Requires: %name-profile

BuildRequires(pre): rpm-macros-meson rpm-build-systemd
BuildRequires: meson libgio-devel >= 2.44.0 libdbus-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_vala:BuildRequires: vala-tools >= 0.18.0}
%{?_enable_gtk_doc:BuildRequires: gtk-doc}
%{?_enable_man:BuildRequires: xsltproc}
%{?_enable_bash_completion:BuildRequires: pkgconfig(bash-completion)}
%{?_enable_check:BuildRequires: /proc dbus}

%description
dconf is a low-level configuration system. Its main purpose is to
provide a backend to GSettings API in Glib for storing and retrieving
application settings.

%package -n lib%name
Summary: Shared library for dconf
Group: System/Libraries

%description -n lib%name
dconf is a low-level configuration system. Its main purpose is to
provide a backend to GSettings API in Glib for storing and retrieving
application settings.

This package provides shared library required for dconf to work

%package -n lib%name-devel
Summary: Development files for dconf library
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
dconf is a low-level configuration system. Its main purpose is to
provide a backend to GSettings API in Glib for storing and retrieving
application settings.

This is a dconf development package. Contains files needed for doing
development using dconf.

%package -n lib%name-devel-doc
Summary: Development documentation for dconf library
Group: Development/Documentation
Conflicts: lib%name < %version
BuildArch: noarch

%description -n lib%name-devel-doc
dconf is a low-level configuration system. Its main purpose is to
provide a backend to GSettings API in Glib for storing and retrieving
application settings.

This package contains development documentation for dconf library.

%package -n lib%name-gir
Summary: GObject introspection data for the dconf library
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the dconf library.

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the dconf library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %EVR
Requires: lib%name-devel = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the dconf library.

%package -n lib%name-vala
Summary: Vala language bindings for the dconf library
Group: Development/Other
BuildArch: noarch
Requires: lib%name = %EVR

%description -n lib%name-vala
This package provides Vala language bindings for the dconf library.

%define _libexecdir %_prefix/libexec

%prep
%setup %{?_enable_snapshot:-a1
    mv gvdb-%gvdb_ver subprojects/gvdb}

%build
%meson \
    -Dsystemduserunitdir=%_userunitdir \
    %{subst_enable_meson_bool gtk_doc gtk_doc} \
    -Dman=true \
    %{subst_enable_meson_bool vala vapi} \
    %{subst_enable_meson_bool bash_completion bash_completion}
%meson_build

%install
%meson_install
mkdir -p %buildroot{%_datadir,%_sysconfdir}/%name/{profile,db/local.d/locks}

# rpm posttrans filetrigger
install -pD -m755 {%_sourcedir,%buildroot%_rpmlibdir}/update-dconf-database.filetrigger

%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_bindir/dconf
%_libdir/gio/modules/libdconfsettings.so
%_libexecdir/dconf-service
%_userunitdir/%name.service
%_datadir/dbus-1/services/ca.desrt.dconf.service
%_rpmlibdir/update-dconf-database.filetrigger
%dir %_sysconfdir/%name
%dir %_sysconfdir/%name/profile
%dir %_sysconfdir/%name/db
%dir %_sysconfdir/%name/db/local.d
%dir %_sysconfdir/%name/db/local.d/locks
%dir %_datadir/%name
%dir %_datadir/%name/profile
%dir %_datadir/%name/db
%if_enabled man
%_man1dir/%name-service.1.*
%_man1dir/%name.1.*
%_man7dir/%name.7.*
%endif
%{?_enable_bash_completion:%_datadir/bash-completion/completions/dconf}
%doc README NEWS

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%if_enabled gtk_doc
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/*

%files -n lib%name-gir-devel
%_girdir/*
%endif

%if_enabled vala
%files -n lib%name-vala
%_vapidir/dconf.deps
%_vapidir/dconf.vapi
%endif

%changelog
