%define master_package cve-manager
%define lists_dist     %{_sysconfdir}/%{master_package}
%define miner          %{master_package}-knowledge-miner
%define python3_sp     /usr/lib/python3/site-packages
%define miner_sp       %{python3_sp}/cve_manager_knowledge_miner
%define mp_ver         0.101.0
%define ax_ver         0.21

Name: %{master_package}-inner-knowledge
Version: 2025.10.57
Release: alt1

Summary: Supplimentary data for cve-manager
License: CC-BY-SA-3.0
Group: Other
Url: https://www.altlinux.org/CVE-Manager

Packager: Alexey Appolonov <alexey@altlinux.org>

# http://git.altlinux.org/people/alexey/packages/?p=%{name}.git
Source: %{name}-%{version}.tar

BuildRequires: rpm-build-python3
Requires: %{master_package} >= %{mp_ver}

ExcludeArch: i586
ExcludeArch: armh

%description
Data used by "cve-manager" to 1) map package names to CPE products (a list of
mapping prescriptions, a list of excluded CPEs and a list of ignored mapping
pairs) and to 2) exclude vulnerabilities that have no real effect in a current
state of specified repositories.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{miner}
Summary: %{master_package} DB client for making specific queries
Group: Other

Requires: python3-module-ax >= %{ax_ver}

%description -n %{miner}
%{miner} helps to get various kinds of information from %{master_package} DB
such as used package names, used CPEs, etc.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%prep
%setup
%build
./publisher -r

%check

%install
mkdir -p \
	%{buildroot}%{lists_dist} \
	%{buildroot}%{_bindir} \
	%{buildroot}%{miner_sp}
install -m0664 *.csv    %{buildroot}%{lists_dist}
install -m0664 *.txt    %{buildroot}%{lists_dist}
install -m0755 %{miner} %{buildroot}%{_bindir}
install -m0750 cve_manager_knowledge_miner/* %{buildroot}%{miner_sp}

%post
# cve group should be created at the post stage of cve-manager installation
chgrp cve %{lists_dist}/*.csv
chgrp cve %{lists_dist}/*.txt

%files
%{lists_dist}/cpe-excluded.csv
%{lists_dist}/fstec-excluded.csv
%{lists_dist}/cpe-mapping.csv
%{lists_dist}/fstec-mapping.csv
%{lists_dist}/cpe-mapping-ignore.csv
%{lists_dist}/fstec-mapping-ignore.csv
%{lists_dist}/cpe-relatives.txt
%{lists_dist}/cpe-not-relatives.txt
%{lists_dist}/fstec-relatives.txt
%{lists_dist}/fstec-not-relatives.txt
%{lists_dist}/excluded-issues.csv
%{lists_dist}/groups.csv
%{lists_dist}/refs-of-products-to-be-excluded.txt
%{lists_dist}/gathered_urls.txt

%files -n %{miner}
%{_bindir}/%{miner}
%{miner_sp}

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%changelog
