%define _cups_serverbin %_libexecdir/cups
%global _localstatedir %_var

Name: cups-filters
Version: 2.0.1
Release: alt1

Summary: OpenPrinting CUPS filters and backends
License: GPLv2 and GPLv2+ and GPLv3 and MIT
Group: System/Servers

Url: http://www.linuxfoundation.org/collaborate/workgroups/openprinting/pdf_as_standard_print_job_format
Source0: http://www.openprinting.org/download/cups-filters/cups-filters-%version.tar
Source1: %name.watch
Patch0: %name-alt.patch
Conflicts: cups < 1.6.1-alt1
Conflicts: ghostscript-cups
Obsoletes: ghostscript-cups
Provides: ghostscript-cups
Obsoletes: foomatic-filters
Provides: foomatic-filters
Conflicts: foomatic-filters

Requires: poppler-utils
Requires: /usr/bin/gs

BuildRequires: libgtk+3-devel
BuildRequires: libppd-devel
Provides: cups-backend-serial = %EVR
Obsoletes: cups-backend-serial < %EVR

%description
Contains backends, filters, and other software that was
once part of the core CUPS distribution but is no longer maintained by
Apple Inc. In addition it contains additional filters developed
independently of Apple, especially filters for the PDF-centric printing
workflow introduced by OpenPrinting.


%prep
%setup
%patch0 -p2

%build
./autogen.sh

%configure --disable-static \
	   --disable-silent-rules \
	   --disable-rpath \
	   --disable-mutool \
	   --enable-driverless \
           --enable-universal-cups-filter \
	   #
%make

%check
make check

%install
%make install DESTDIR=%buildroot
ln -sf ../lib/cups/filter/universal %buildroot/%_bindir/foomatic-rip
rm -rf %buildroot%_docdir/%name
mkdir -p %buildroot/%_datadir/cups/data/


%files
%doc README.md AUTHORS NEWS
%attr(0755,root,root) %_cups_serverbin/filter/*
%attr(0755,root,root) %_cups_serverbin/driver/*
%attr(0755,root,root) %_cups_serverbin/backend/parallel
%attr(0755,root,root) %_cups_serverbin/backend/beh
%attr(0755,root,root) %_cups_serverbin/backend/driverless
%attr(0755,root,root) %_cups_serverbin/backend/driverless-fax
%attr(0700,root,root) %_cups_serverbin/backend/serial
%_datadir/cups/drv/cupsfilters.drv
%_datadir/cups/mime/cupsfilters.types
%_datadir/cups/mime/cupsfilters.convs
%_datadir/cups/mime/cupsfilters-universal-postscript.convs
%_datadir/cups/mime/cupsfilters-universal.convs
%_datadir/ppdc/escp.h
%_datadir/ppdc/pcl.h
%_datadir/ppd/cupsfilters
%_bindir/foomatic-rip
%_bindir/driverless
%_bindir/driverless-fax
%_datadir/man/man*/*

%changelog
