%define version_SingleApplication v3.5.1
%define version_QHotkey 1.5.0
%define version_Breeze 6.7.0

Name: crow-translate
Version: 3.1.0
Release: alt1

Summary: A Qt GUI for Google, Yandex and Bing translators
Summary(ru_RU.UTF-8): GUI интерфейс Qt для переводчиков Google, Yandex и Bing

License: GPL-3.0-only and MIT and BSD-3-Clause
Group: System/Internationalization
Url: https://invent.kde.org/office/crow-translate

# Source-url: https://invent.kde.org/office/crow-translate/-/archive/v%version/crow-translate-v%version.tar.gz
Source: %name-%version.tar

# Source1-url: https://github.com/itay-grudev/SingleApplication/archive/refs/tags/%version_SingleApplication.tar.gz
Source1: SingleApplication.tar

# Source2-url: https://github.com/Skycoder42/QHotkey/archive/refs/tags/%version_QHotkey.tar.gz
Source2: QHotkey.tar

# Source3-url: https://invent.kde.org/frameworks/breeze-icons/-/archive/v%version_Breeze/breeze-icons-v%version_Breeze.tar.gz
Source3: Breeze-icon-theme.tar

BuildRequires: extra-cmake-modules
BuildRequires: libleptonica-devel
BuildRequires: qt5-multimedia-devel
BuildRequires: qt5-tools-devel
BuildRequires: qt5-x11extras-devel
BuildRequires: kf5-kwayland-devel
BuildRequires: tesseract-devel >= 4.0.0
BuildRequires: libqt5-concurrent
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libqt5-dbus

BuildRequires(pre): rpm-macros-cmake

Requires: tesseract >= 4.0.0
Requires: icon-theme-breeze
Requires: libqt5-svg

%description
A simple and lightweight translator that allows you to translate and voice text
using Google, Yandex and Bing, written in Qt5 for KDE5.
To make the application look native in DE built on GTK, you need to customize
the Qt application style with plugins like qt5ct, adwaita-qt5.
Recommended icons for the Breeze app.

%description -l ru_RU.UTF-8
Простой и легкий переводчик, позволяющий переводить и озвучивать текст с
помощью Google, Yandex и Bing, написанный на Qt5 для KDE5.
Чтобы приложение выглядело родным в DE, построенном на GTK, вам нужно настроить
стиль приложения Qt с помощью плагинов, таких как qt5ct, adwaita-qt5.
Рекомендуемые значки для приложения Breeze.

%prep
%setup

%ifarch %e2k
# workaround of SIGILL in ecf_opt64 from LCC 1.25.23
sed -i -E "s/qOverload<([^>]*)>\(&([^:]*::)/(void(\\2*)(\\1))(\&\\2/" \
	src/mainwindow.cpp
%endif

tar -xf %SOURCE1 -C src/3rdparty/singleapplication/ --strip-components=1
tar -xf %SOURCE2 -C src/3rdparty/qhotkey/ --strip-components=1
tar -xf %SOURCE3 -C data/icons/3rdparty/breeze-icons --strip-components=1

# Analog of crow-2.10.0-alt-desktop.patch
subst "s|Categories=Office;Qt;|Categories=Qt;Graphics;OCR;Scanning;|" data/org.kde.CrowTranslate.desktop.in

# Fix QX11Info: No such file or directory
subst "s|<QX11Info>|<QtX11Extras/QX11Info>|" src/mainwindow.cpp
subst "s|<QX11Info>|<QtX11Extras/QX11Info>|" src/ocr/screengrabbers/abstractscreengrabber.cpp
subst "s|<QX11Info>|<QtX11Extras/QX11Info>|" src/ocr/snippingarea.cpp
subst "s|<QX11Info>|<QtX11Extras/QX11Info>|" src/xdgdesktopportal.cpp

%build
%cmake \
    -DWITH_KWAYLAND=ON

%cmake_build

%install
%cmake_install
%find_lang %name --with-qt

%files -f %name.lang
%doc README.md
%_bindir/crow
%_desktopdir/org.kde.CrowTranslate.desktop
%_datadir/metainfo/org.kde.CrowTranslate.metainfo.xml
%_iconsdir/hicolor/*/*/org.kde.CrowTranslate*

%changelog
