
%global provider github.com
%global project cri-o
%global repo cri-o

%global provider_prefix %provider/%project/%repo
%global import_path %provider_prefix

%global _unpackaged_files_terminate_build 1

%define _libexecdir /usr/libexec

%define prog_name            cri-o
%define cri_o_major          1
%define cri_o_minor          26
%define cri_o_patch          4

Name: %prog_name%cri_o_major.%cri_o_minor
Version: %cri_o_major.%cri_o_minor.%cri_o_patch
Release: alt5
Summary: Kubernetes Container Runtime Interface for OCI-based containers
Group: Development/Other
License: Apache-2.0
URL: https://cri-o.io
VCS: https://github.com/cri-o/cri-o
ExclusiveArch: %go_arches

Source: %name-%version.tar
Patch:  %name-%version-%release.patch

Provides: %prog_name = %EVR
Conflicts: %prog_name < %EVR
Conflicts: %prog_name > %EVR

Requires: containers-common
Requires: runc
Requires: cni-plugins
Requires: conntrack-tools
Requires: iproute2
Requires: iptables
Requires: socat
Requires: conmon

BuildRequires(pre): rpm-build-golang
BuildRequires(pre): golang >= 1.19
BuildRequires: glib2-devel
BuildRequires: glibc-devel-static
BuildRequires: libbtrfs-devel
BuildRequires: libdevmapper-devel
BuildRequires: libgpgme-devel libassuan-devel
BuildRequires: libseccomp-devel
BuildRequires: libselinux-devel
BuildRequires: libsystemd-devel
BuildRequires: go-md2man
BuildRequires: /proc
Provides: oci-runtime = 2
Provides: cri-runtime

%description
%summary

%prep
%setup
%autopatch -p1

sed -i 's/\/local//' contrib/systemd/crio.service
sed -i 's/\/local//' contrib/systemd/crio-wipe.service
sed -i 's/\/local//' docs/crio.8.md
sed -i 's/\/local//' docs/crio.conf.5.md

sed -i 's/install.config: crio.conf/install.config:/' Makefile
sed -i 's/install.bin: binaries/install.bin:/' Makefile
sed -i 's/\.gopathok//' Makefile
sed -i 's|$(PREFIX)/lib/systemd/system|$(DESTDIR)%_unitdir|g' Makefile

%build
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"

%golang_prepare

export COMMIT_NO=%release
export GIT_TREE_STATE=clean
export BRANCH=altlinux
export GOFLAGS="-mod=vendor"

cd .build/src/%import_path
%make

%install
cd .build/src/%import_path
./bin/crio \
      --cgroup-manager "systemd" \
      --storage-driver "overlay" \
      --root "/var/lib/containers/storage" \
      --runroot "/var/run/containers/storage" \
      --listen "/var/run/crio/crio.sock" \
      --conmon "%_bindir/conmon" \
      --cni-plugin-dir "%_libexecdir/cni,/opt/cni/bin" \
      --storage-opt "overlay.override_kernel_check=1" \
      config > ./crio.conf

# install conf files
install -dp %buildroot%_sysconfdir/cni/net.d
install -p -m 644 contrib/cni/10-crio-bridge.conflist %buildroot%_sysconfdir/cni/net.d/100-crio-bridge.conflist.sample
install -p -m 644 contrib/cni/99-loopback.conflist %buildroot%_sysconfdir/cni/net.d/200-loopback.conflist.sample

%make PREFIX=%buildroot%prefix DESTDIR=%buildroot \
            install.bin \
            install.completions \
            install.config \
            install.man \
            install.systemd

%post
%post_systemd crio.service

%preun
%preun_systemd crio.service

%files
%_bindir/crio
%_bindir/crio-status
%_bindir/pinns
%_man5dir/crio.conf.*
%_man8dir/crio.*
%_man8dir/crio-status.*
%dir %_sysconfdir/crio
%config(noreplace) %_sysconfdir/crio/crio.conf
%_sysconfdir/cni/net.d/100-crio-bridge.conflist.sample
%_sysconfdir/cni/net.d/200-loopback.conflist.sample
%config(noreplace) %_sysconfdir/crictl.yaml
%_unitdir/*.service
%_datadir/oci-umount
%_datadir/bash-completion/completions/*
%_datadir/fish/completions/*
%_datadir/zsh/site-functions/*

%changelog
