%define crda_lib %_libexecdir/crda
%define sbindir /sbin
%define _db wireless-regdb
%define _db_date 2025.10.07

Summary: Regulatory compliance agent for 802.11 wireless networking
Name: crda
Version: 4.15
Release: alt7.%_db_date
License: copyleft-next-0.3.0
Group: Networking/Other
# wireless-regdb git://git.kernel.org/pub/scm/linux/kernel/git/sforshee/wireless-regdb.git
Url: https://wireless.docs.kernel.org/en/latest/en/developers/regulatory/crda.html

Requires: firmware-%_db >= %EVR

Source: %name-%version.tar
Source1: %_db.tar
Source2: setregdomain
Source3: setregdomain.1

# Add udev rule to call setregdomain on wireless device add
Patch: crda-3.18-regulatory-rules-setregdomain.patch
# Do not call ldconfig in crda Makefile
Patch1: crda-remove-ldconfig.patch
Patch2: crda-ldflags.patch
Patch3: %_db-fw-dependency.patch
Patch4: %_db-pubcert-conf.patch
# https://gitweb.gentoo.org/repo/gentoo.git/plain/net-wireless/crda/files/crda-4.14-python-3.patch
Patch5: crda-4.14-python-3.patch
# https://wireless.docs.kernel.org/en/latest/en/developers/regulatory/crda.html#build-requirements
Patch6: crda-4.15-update-pubkeys.patch

BuildRequires: libgcrypt-devel openssl chrpath
BuildRequires: rpm-build-python3
BuildRequires: python3-module-attrs python3-module-m2crypto

BuildRequires: kernel-headers >= 2.6.27
BuildRequires: libnl-devel >= 1.1

%description
CRDA is no longer needed as of kernel v4.15 since commit 007f6c5e6eb45
("cfg80211: support loading regulatory database as firmware file") added
support to use the kernel's firmware request API which looks for the
firmware on /lib/firmware. Because of this CRDA is legacy software for
older kernels. It will continue to be maintained.

CRDA acts as the udev helper for communication between the kernel
and userspace for regulatory compliance. It relies on nl80211
for communication. CRDA is intended to be run only through udev
communication from the kernel.

%package devel
Summary: Header files for use with libreg
Group: Development/Tools
BuildArch: noarch

%description devel
Header files to make use of libreg for accessing regulatory info.

%package -n firmware-%_db
Summary: Central Regulatory Database
Group: System/Kernel and hardware
BuildArch: noarch

%description -n firmware-%_db
This repository contains the regulatory database file for use with Central
Regulatory Database Agent daemon (CRDA).

%prep
%setup -c
%setup -T -D -a 1

# Set correct python3 executable in shebang
subst 's|#!.*python$|#!%__python3|' $(grep -Rl '#!.*python$' *)

cd %name-%version
%patch -p1 -b .setregdomain
%patch1 -p2 -b .ldconfig-remove
%patch2 -p2 -b .ldflags
%patch5 -p1
%patch6 -p2
%ifarch %e2k
sed -i 's/-Werror/-Wno-error/g' Makefile
%endif
cd ../%_db
%patch3 -p2 -b .fwsign
%patch4 -p2 -b .pubcert

%build
%add_optflags %optflags_shared
export CFLAGS="%optflags -Wno-error=unused-const-variable"
cd %name-%version
%make SBINDIR=%sbindir/ LIBDIR=%crda_lib \
	REG_BIN=../%_db/regulatory.bin V=1

%install
cd crda-%version
%makeinstall_std MANDIR=%_mandir SBINDIR=%sbindir/ LIBDIR=%_libdir UDEV_RULE_DIR=%_udevrulesdir

cd ../%_db
%makeinstall_std PREFIX='' CRDA_PATH=%crda_lib MANDIR=%_mandir
install -D -pm 0755 %SOURCE2 %buildroot/sbin
install -D -pm 0644 %SOURCE3 %buildroot%_man1dir/setregdomain.1
install -d %buildroot%_sysconfdir/%_db/pubkeys

rm %buildroot%_man5dir/regulatory.db.5* ||:
rm -f %buildroot/lib/%name/pubkeys/linville.key.pub.pem
ln -s regulatory.bin.5 %buildroot%_man5dir/regulatory.db.5

%files
%doc %name-%version/LICENSE %name-%version/README

%_libdir/libreg.so
%dir %crda_lib
%crda_lib/*
# distribution custom keys
%_sysconfdir/%_db
%sbindir/%name
%sbindir/regdbdump
%sbindir/setregdomain
%_udevrulesdir/85-regulatory.rules

%_man1dir/setregdomain.1*
%_man5dir/regulatory.*.5*
%_man8dir/crda.8*
%_man8dir/regdbdump.8*

%files -n firmware-%_db
%doc %_db/README %_db/LICENSE
/lib/firmware/*.db*

%files devel
%_includedir/reglib

%changelog
