%define courier_confdir	%_sysconfdir/%name
%define courier_authdir %_sysconfdir/courier-authlib
%define courier_datadir	%_datadir/%name
%define courier_localstatedir %_localstatedir/%name
%define courier_piddir %_var/run
%define _ssldir %_localstatedir/ssl
%define _pemdir %_ssldir/private
%define rev %nil

# valgrind doesn't work right on other arches :(
%ifarch %ix86 x86_64
%def_enable check
%else
%def_disable check
%endif

Name: courier-imap
Version: 5.2.11
Release: alt1%rev

Summary: IMAP/POP3 server with Maildir support
License: GPL-3
Group: System/Servers
Url: http://www.courier-mta.org

Requires(pre): cert-sh-functions >= 0.1-alt2 shadow-utils
Requires(post,preun): service
Requires: courier-common-utils

Source0: %name-%version%rev.tar.bz2
Source1: courier-imapd.init
Source2: courier-imaps.init
Source3: courier-pop3d.init
Source4: courier-pop3s.init
Source7: %name.README-ALT
Source8: common-login.authpam
Source9: ssl-sh-functions

Patch0: %name-5.1.4-alt-makefile.patch
Patch2: %name-4.17.2-alt-imapaccess.patch
Patch3: %name-4.17.2-alt-imap-ssl-configure.patch
Patch4: %name-4.17.2-alt-pamconf.patch
Patch5: %name-4.17.2-alt-quotawarn.patch
Patch6: %name-5.1.4-alt-shareddir.patch
Patch7: %name-5.1.8-alt-sysconftool.patch
Patch8: %name-5.1.4-alt-tls-enforce-config.patch
Patch9: %name-4.17.2-alt-config.patch

BuildPreReq: libcourier-authlib-devel >= 0.71.0

# Automatically added by buildreq on Sun Apr 27 2008
BuildRequires: gcc-c++ libdb4-devel libkrb5-devel libpcre2-devel libssl-devel openssl libpam-devel pam-config libidn2-devel >= 2.0.5
BuildRequires: courier-unicode-devel >= 2.1
%{?_enable_check:BuildRequires: valgrind}

# Files /etc/pam.d/imap /usr/share/man/man8/imapd.8.xz conflict with the package cyrus-imapd
Conflicts: cyrus-imapd

%description
Courier-IMAP is an IMAP server for Maildir mailboxes.  This package contains
the standalone version of the IMAP server that's included in the Courier
mail server package.  This package is a customized version for use with
other mail servers.

%prep
%setup -n %name-%version%rev
%patch0 -p2 -b .p0
%patch2 -p2 -b .p2
%patch3 -p2 -b .p3
%patch4 -p2 -b .p4
%patch5 -p2 -b .p5
%patch6 -p2 -b .p6
%patch7 -p2 -b .p7
%patch8 -p2 -b .p8
%patch9 -p2 -b .p9
cp %SOURCE8 libs/imap/

%build
%autoreconf
%configure \
    --sysconfdir=%courier_confdir \
    --localstatedir=%courier_localstatedir \
    --datadir=%courier_datadir \
    --enable-unicode \
    --with-userdb=%courier_authdir/userdb \
    --with-makedatprog=%_bindir/makedatprog \
    --with-db=db \
    --with-certsdir=%courier_confdir/ssl \
    --with-certdb=%_datadir/ca-certificates/ca-bundle.crt \
    --with-piddir=%courier_piddir \
    --with-mailer=%_sbindir/sendmail \
    --with-redhat \
    --with-notice=unicode

%make_build

%install
# adjust $RPM_BUILD for install
mkdir -p %buildroot%_sysconfdir/pam.d
mkdir -p %buildroot%_initdir
mkdir -p %buildroot%courier_localstatedir
touch %buildroot%courier_localstatedir/{couriersslimapcache,couriersslpop3cache}

make DESTDIR=%buildroot install

# tune configfiles
for i in `ls %buildroot%courier_confdir/*.dist | sed -e 's/\.dist//'`; do
	mv $i.dist $i
done
touch %buildroot%courier_confdir/{imap,pop3}d.custom.cnf
install -m 0644 %SOURCE9 %buildroot%courier_confdir

# install configs and init scripts
install -m 0755 %SOURCE1 %buildroot%_initdir/courier-imapd
install -m 0755 %SOURCE2 %buildroot%_initdir/courier-imaps
install -m 0755 %SOURCE3 %buildroot%_initdir/courier-pop3d
install -m 0755 %SOURCE4 %buildroot%_initdir/courier-pop3s

mkdir -p -m 0755 %buildroot%_sysconfdir/pam.d
install -m 0644 libs/imap/imapd.pam %buildroot%_sysconfdir/pam.d/imap
install -m 0644 libs/imap/pop3d.pam %buildroot%_sysconfdir/pam.d/pop3

mkdir -p -m 0755 %buildroot%courier_confdir/ssl
touch %buildroot%courier_confdir/ssl/{imapd.pem,pop3d.pem,imapd.dh,pop3d.dh}

mv %buildroot%courier_confdir/quotawarnmsg.example %buildroot%courier_confdir/quotawarnmsg

# root src documentation
mkdir -p %buildroot%_docdir/%name-%version/html
install -m 0644 %SOURCE7 %buildroot%_docdir/%name-%version/README-ALT.utf8
install -m 0644 AUTHORS %buildroot%_docdir/%name-%version
install -m 0644 INSTALL %buildroot%_docdir/%name-%version
install -m 0644 NEWS    %buildroot%_docdir/%name-%version
install -m 0644 README  %buildroot%_docdir/%name-%version
install -m 0644 INSTALL.html %buildroot%_docdir/%name-%version/html
install -m 0644 NEWS.html    %buildroot%_docdir/%name-%version/html

# imap documentation
install -m 0644 libs/imap/BUGS      %buildroot%_docdir/%name-%version
install -m 0644 libs/imap/ChangeLog %buildroot%_docdir/%name-%version
install -m 0644 libs/imap/README.proxy %buildroot%_docdir/%name-%version
install -m 0644 libs/imap/BUGS.html    %buildroot%_docdir/%name-%version/html
install -m 0644 libs/imap/courierpop3d.html %buildroot%_docdir/%name-%version/html
install -m 0644 libs/imap/courierpop3d.8 %buildroot%_man8dir
install -m 0644 libs/imap/README.proxy.html %buildroot%_docdir/%name-%version/html

# maildir documentation
install -m 0644 libs/maildir/README.maildirquota.txt  %buildroot%_docdir/%name-%version
install -m 0644 libs/maildir/README.sharedfolders.txt %buildroot%_docdir/%name-%version
install -m 0644 libs/maildir/maildiracl.html %buildroot%_docdir/%name-%version/html
install -m 0644 libs/maildir/maildir.html    %buildroot%_docdir/%name-%version/html
install -m 0644 libs/maildir/maildirkw.html  %buildroot%_docdir/%name-%version/html
install -m 0644 libs/maildir/maildirmake.html  %buildroot%_docdir/%name-%version/html
install -m 0644 libs/maildir/maildirquota.html %buildroot%_docdir/%name-%version/html
install -m 0644 libs/maildir/README.imapkeywords.html  %buildroot%_docdir/%name-%version/html
install -m 0644 libs/maildir/README.maildirfilter.html %buildroot%_docdir/%name-%version/html
install -m 0644 libs/maildir/README.maildirquota.html  %buildroot%_docdir/%name-%version/html
install -m 0644 libs/maildir/README.sharedfolders.html %buildroot%_docdir/%name-%version/html

# tcpd/tls documentation
install -m 0644 libs/tcpd/README.couriertls %buildroot%_docdir/%name-%version
install -m 0644 libs/tcpd/couriertls.html %buildroot%_docdir/%name-%version/html
install -m 0644 libs/tcpd/couriertls.1 %buildroot%_man1dir

%if_enabled check
%check
%make check
%endif

%triggerun -- courier-imap < 4.18.0
echo 'WARNING! WARNING! non-UTF-8 friendly configuration detected!'
echo 'Outdated mailboxes need UTF-8 conversion, manual intervention needed!'
echo 'Please read INSTALL documentation about upgrade from courier-imap < 4.18.0'
echo 'and earlier'
echo 'WARNING! WARNING!'
echo 'Courier-imap have switched to inotify instead of gamin'
echo 'Please read INSTALL documentation about adjusting kernel parameters'
echo 'for inotify use'

%post
# try to update configs from .rpmsave
for i in imapd pop3d; do
	if [ -f %courier_confdir/$i.rpmsave ]; then
		. %courier_confdir/$i.rpmsave
		subst "s|^ADDRESS=127.0.0.1|ADDRESS=$ADDRESS|" %courier_confdir/$i
	fi
done
for i in imapd-ssl pop3d-ssl; do
	if [ -f %courier_confdir/$i.rpmsave ]; then
		. %courier_confdir/$i.rpmsave
		subst "s|^SSLADDRESS=127.0.0.1|SSLADDRESS=$SSLADDRESS|" %courier_confdir/$i
	fi
done

%post_service courier-imapd
%post_service courier-pop3d
%post_service courier-imaps
%post_service courier-pop3s

%preun
%preun_service courier-imapd
%preun_service courier-imaps
%preun_service courier-pop3d
%preun_service courier-pop3s

%files
%_initdir/courier-imapd
%_initdir/courier-imaps
%_initdir/courier-pop3d
%_initdir/courier-pop3s
%dir %courier_confdir
%dir %courier_confdir/ssl
%courier_confdir/ssl-sh-functions
%config %courier_confdir/imapd
%config %courier_confdir/pop3d
%config %courier_confdir/imapd-ssl
%config %courier_confdir/pop3d-ssl
%config(noreplace) %_sysconfdir/pam.d/imap
%config(noreplace) %_sysconfdir/pam.d/pop3
%ghost %attr(0640,root,root) %config(noreplace,missingok) %courier_confdir/imapd.custom.cnf
%ghost %attr(0640,root,root) %config(noreplace,missingok) %courier_confdir/pop3d.custom.cnf
%courier_confdir/quotawarnmsg
%_bindir/maildiracl
%_bindir/makeimapaccess
%_sbindir/couriertls
%_sbindir/couriertcpd
%_sbindir/imapd
%_sbindir/imaplogin
%_sbindir/pop3d
%_sbindir/pop3login
%_sbindir/sharedindexinstall
%_sbindir/sharedindexsplit
%_man1dir/couriertcpd.1*
%_man1dir/couriertls.1*
%_man1dir/maildiracl.1*
%_man8dir/courierpop3d.8*
%_man8dir/imapd.8*
%_man8dir/makeimapaccess.8*
%dir %_docdir/%name-%version
%doc %_docdir/%name-%version/*
%ghost %attr(0640,root,courier) %config(noreplace,missingok) %courier_confdir/ssl/imapd.dh
%ghost %attr(0640,root,courier) %config(noreplace,missingok) %courier_confdir/ssl/pop3d.dh
%ghost %attr(0600,courier,courier) %config(noreplace,missingok) %courier_confdir/ssl/imapd.pem
%ghost %attr(0600,courier,courier) %config(noreplace,missingok) %courier_confdir/ssl/pop3d.pem
%dir %attr(0750,root,courier) %courier_localstatedir
%dir %attr(0750,root,courier) %courier_localstatedir/imapaccess
%ghost %attr(0600,courier,courier) %courier_localstatedir/couriersslimapcache
%ghost %attr(0600,courier,courier) %courier_localstatedir/couriersslpop3cache

%changelog
