%def_with tests

Name: corectrl
Version: 1.5.2
Release: alt1
Summary: Core control application
Group: System/Configuration/Hardware
License: GPLv3
Url: https://gitlab.com/%name/%name
Source: https://gitlab.com/%name/%name/-/archive/v%{version}/%name-%version.tar
Patch: %name-%version-%release.patch
Source1: 90-%name.rules
Source2: %name.control

BuildRequires(pre): cmake
BuildRequires: libbotan-devel libdbus-devel libdrm-devel libpolkit-devel qt6-charts-devel qt6-svg-devel qt6-tools-devel quazip-qt6-devel
BuildRequires: libfmt-devel >= 5.0, libpugixml-devel >= 1.11 ctest nholthaus-units-devel libspdlog-devel
%if_with tests
BuildRequires: catch-devel trompeloeil-devel
%endif
Requires: hwdata libqt6-quickcontrols2universal libqt6-chartsqml

%description
CoreCtrl is a Free and Open Source GNU/Linux application that allows you to
control with ease your computer hardware using application profiles. It aims to
be flexible, comfortable and accessible to regular users.

%prep
%setup
%patch -p1
# stdc++fs is a part of libstdc++ on linux
find . -name CMakeLists.txt -exec sed -i -e 's/stdc++fs/stdc++/g' {} \;

%build
%cmake \
  -DCMAKE_BUILD_TYPE=RelWithDebInfo \
  %if_with tests
  -DBUILD_TESTING=TRUE \
  %endif
  %nil
%cmake_build

%check
make -C "%_cmake__builddir" test

%install
%cmake_install
install -pD -m644 %SOURCE1 %buildroot%_sysconfdir/polkit-1/rules.d/90-%name.rules
install -pD -m755 %SOURCE2 %buildroot%_controldir/%name

%pre
/usr/sbin/groupadd -r -f %name
if [ $1 -ge 2 -o -e %_bindir/%name ]; then
    %_sbindir/control-dump %name
fi

%post
echo 'Do not forget to add yourself into %name group before running %name for the first time!'
echo 'Or use control(8) command to tune access later.'
if [ $1 -ge 2 -o -e %_bindir/%name ]; then
    %_sbindir/control-restore %name
else
    %_sbindir/control %name %{name}only
fi

%files
%doc README.md CHANGELOG.md COPYING LICENSE CONTRIBUTING.md
%config %_controldir/*
%config %_sysconfdir/polkit-1/rules.d/*
%attr(710,root,%name) %_bindir/%name
%_libdir/lib%{name}.so
%_prefix/libexec/%name
%_desktopdir/org.corectrl.CoreCtrl.desktop
%_datadir/dbus-1/system-services/org.%name.*.service
%_datadir/dbus-1/system.d/org.%name.*.conf
%_iconsdir/hicolor/*/apps/*.svg
%_datadir/metainfo/org.corectrl.CoreCtrl.appdata.xml
%_datadir/polkit-1/actions/org.%name.*.policy

%changelog
