# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: converseen
Version: 0.15.0.1
Release: alt1
Summary: Converseen is a free cross-platform batch image processor
Summary(ru_RU.UTF-8): Converseen — свободная программа пакетного конвертирования изображений
License: GPL-3.0-or-later
Group: Graphics
URL: https://converseen.fasterland.net/
VCS: https://github.com/Faster3ck/Converseen

BuildRequires(pre): rpm-macros-cmake
BuildRequires: desktop-file-utils
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: ImageMagick-tools
BuildRequires: libImageMagick-devel
BuildRequires: qt6-base-devel
BuildRequires: qt6-designer
BuildRequires: qt6-tools-devel

Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: ImageMagick-tools

%description
Converseen is a free cross-platform batch image processor for Windows and Linux
that allows you to convert, resize, rotate and flip an infinite number of
images with a mouse click.
Moreover, Converseen is able to transform an entire PDF file into a bunch
of images with the characteristics you prefer: you can choose one of the 100+
formats, you can set the size, resolution and the filename.

%description -l ru_RU.UTF-8
Converseen — свободная кроссплатформенная программа для Windows и Linux 
для пакетного конвертирования, изменения размера, поворота изображений в один
клик.
Кроме того, Converseen способен преобразовать вашу коллекцию изображений в PDF
файл с характеристиками, которые вы предпочитаете: вы можете выбрать один из
более чем 100 форматов, установить размер, разрешение и имя файла.

%prep
%setup -n %name-%version

%build
%cmake -DUSE_QT6=on
%cmake_build

%install
%cmake_install
desktop-file-validate %buildroot/%_desktopdir/net.fasterland.converseen.desktop

%files
%doc COPYING.txt README.md CHANGELOG
%_bindir/%name
%_datadir/%name
%_datadir/kio/servicemenus/converseen_import.desktop
%_iconsdir/hicolor/*/apps/%name.png
%_desktopdir/net.fasterland.converseen.desktop
%_datadir/metainfo/%name.appdata.xml

%changelog
