Name: control
Version: 0.8.1
Release: alt1

Summary: A set of scripts to control installed system facilities
License: GPLv2+
Group: System/Base
BuildArch: noarch

Source: %name-%version.tar

# due to sed -i support
Requires: sed >= 1:4.1.1

%define _controldir %_sysconfdir/control.d/facilities

%description
The scripts included in this package provide a common interface to
control system facilities provided by a number of other packages.
This is intended for use primarily by packages which are providing
a facility that can potentially be dangerous to system security,
to let you enable, disable, or configure the facility independently
from package installation.

%prep
%setup

%build
sed -i s/@VERSION@/%version-%release/ control

%install
mkdir -p %buildroot{%_controldir,%_sbindir,%_man8dir,%_mandir/ru/man8,/var/run/control}
install -p -m755 control{,-dump,-restore} %buildroot%_sbindir/
install -p -m755 functions %buildroot%_sysconfdir/control.d/
install -p -m644 control{,-dump,-restore}.8 %buildroot%_man8dir/
install -p -m644 ru/control{,-dump,-restore}.8 %buildroot%_mandir/ru/man8/
install -pD -m644 control.macros %buildroot%_rpmmacrosdir/control
install -pD -m644 bash_completions %buildroot%_datadir/bash-completion/completions/control

# Generate shell functions provides list.
(
	echo '# shell functions provides list'
	for f in %buildroot%_sysconfdir/control.d/*; do
		[ -f "$f" -a -x "$f" ] || continue
		sed -ne 's/^\([A-Za-z][A-Za-z_0-9]*[[:space:]]*\)()$/\1/pg' "$f"
	done |LC_COLLATE=C sort -u
) >%buildroot%_controldir/.provides.sh

%check
bash -n bash_completions

%files
%_sbindir/control*
%_rpmmacrosdir/control
%config %_sysconfdir/control.d
%attr(0700,root,root) %ghost /var/run/control/
%_man8dir/*.8*
%_mandir/ru/man8/*.8*
%_datadir/bash-completion/completions/control

%changelog
