%def_enable  openssl
%def_enable  hunspell
%def_without devel

Summary: CONE mail reader
Name: cone
Version: 1.14
Release: alt0.1
Url: http://www.courier-mta.org/cone
Source0: %name-%version.tar
License: GPLv3
Group: Networking/Mail

Patch1: cone-alt-sendmail.patch
Patch2: cone-alt-app-defaults.patch
Patch3: cone-1.6-alt-m4.patch

Packager: L.A. Kostis <lakostis@altlinux.org>

BuildRequires: libaspell-devel libxml2-devel
BuildRequires: zlib-devel libgamin-devel perl libncursesw-devel
BuildRequires: libstdc++-devel gcc-c++
BuildRequires: openldap-devel libidn2-devel courier-unicode-devel
BuildRequires: gnupg2 libpcre2-devel

%if_enabled openssl
BuildRequires: openssl
BuildRequires: openssl-devel
%else
BuildRequires: gnutls-devel libgcrypt-devel
%endif
%if_enabled hunspell
BuildRequires: libhunspell-devel hunspell
Requires: hunspell
%endif

Requires(post): perl

%description
CONE is a simple, text-based E-mail reader and writer.

%if_with devel
%package devel-static
Group: Development/C++
Summary: LibMAIL mail client development library
Requires: %name = 0:%version-%release

%description devel-static
The %name-devel package the header files and library files for developing
application using LibMAIL - a high level, C++ OO library for mail clients.
%endif

%prep
%setup -q
%patch1 -p2
%patch2 -p2
%patch3 -p2
for d in curses libmail cone; do
pushd "$d"
ln -s ../{NEWS,README,AUTHORS,ChangeLog} . ||:
popd
done

%autoreconf
%configure -C \
            --with-notice=unicode \
	    --libexecdir=%_prefix/libexec \
	    --with-certdb=%_datadir/ca-certificates/ca-bundle.crt \
	    %if_enabled hunspell
	    --with-spellcheck=hunspell \
	    %endif
	    %subst_with devel
%build
%make_build
%install
make install DESTDIR=%buildroot
install sysconftool %buildroot%_datadir/cone/cone.sysconftool
touch %buildroot%_sysconfdir/cone

# Remove dupe copies of doc/html from the install tree.
ls cone/html | ( cd %buildroot%_datadir/cone && xargs -n10 rm -f )

%post
perl %_datadir/cone/cone.sysconftool %_sysconfdir/cone.dist >/dev/null

%triggerun -- cone < 0.96
echo 'WARNING! WARNING!'
echo 'Outdated cone version detected, manual intervention needed!'
echo 'Please read INSTALL documentation about upgrade from cone 0.96'
echo 'and earlier'

%files
%attr(644,root,root) %_sysconfdir/cone.dist
%ghost %verify(user group mode) %attr(644,root,root) %_sysconfdir/cone
%_bindir/*
%_prefix/libexec/cone
%_datadir/cone
%_man1dir/*
%doc ChangeLog README NEWS AUTHORS COPYING COPYING.GPL INSTALL

%if_with devel
%files devel-static
%_libdir/*.a
%_mandir/man[35]/*
%_includedir/libmail
%doc cone/html
%endif

%changelog
