%define _unpackaged_files_terminate_build 1

%define _localstatedir %_var
%define _libexecdir    /usr/libexec
%define cockpit_user   _cockpit-ws
%define cockpit_group  _cockpit-ws
%define cockpit_wsinstance_user  _cockpit-wsinstance

%def_with doc

%def_with optional
%define with_packagekit 1

%if_without optional
# force disable
%define with_packagekit 0
%endif

%if %with_packagekit
%def_with packagekit
%else
%def_without packagekit
%endif

%def_with check

###############################################################################

Name: cockpit
Version: 336.2
Release: alt3

Summary: Web Console for Linux servers
License: LGPLv2+
Group: System/Base
VCS: https://github.com/cockpit-project/cockpit.git
Url: https://cockpit-project.org/
Source0: %name-%version.tar
Source1: cockpit.alt.pam
Patch: %name-%version-alt.patch

# Automatically generated by sub-merge
# https://github.com/allisonkarlitskaya/beipack
Source10: beipack-4217d8ade60885a18156e86e566b808edad000ee-sub-merged.tar
# https://github.com/allisonkarlitskaya/ferny
Source11: ferny-c8713c4d3ba74a9d8db1ce8e0a15296e6a333257-sub-merged.tar
# https://github.com/cockpit-project/node-cache.git
Source12: node-cache-f7b5d7625b42c301aaaee4fb48df6f60d28f3b2b-sub-merged.tar
# https://github.com/cockpit-project/pixel-test-reference
Source13: pixel-test-reference-f2ff51fea8bf5abd7ec0b37b27e36339cb0c1063-sub-merged.tar
# https://github.com/allisonkarlitskaya/systemd_ctypes.git
Source14: systemd_ctypes-833f5cee8ea5d4c93aecf0ac2bf517cd5b52f5ec-sub-merged.tar

BuildRequires(pre): rpm-macros-pam0
BuildRequires(pre): rpm-macros-python3

BuildRequires: node
BuildRequires: libgnutls-devel
BuildRequires: libjson-glib-devel
BuildRequires: libsystemd-devel
BuildRequires: libpolkit-devel
BuildRequires: libkrb5-devel
BuildRequires: libpam0-devel

BuildRequires: xsltproc

BuildRequires: pip

%if_with doc
BuildRequires: xmlto
%endif

%if_with check
BuildRequires: glib-networking
BuildRequires: polkit
BuildRequires: openssh-common
BuildRequires: openssh-clients
BuildRequires: dbus
BuildRequires: /proc
BuildRequires: /dev/pts
%endif

# e.g. cockpit-client is written in Python
BuildRequires: rpm-build-python3

Requires: cockpit-bridge
Requires: cockpit-ws
Requires: cockpit-system
# Optional components
Requires: cockpit-networkmanager
Requires: cockpit-storaged
%if_with packagekit
Requires: cockpit-packagekit
%endif

%description
The Cockpit Web Console enables users to administer GNU/Linux servers using a
web browser.

It offers network configuration, log inspection, diagnostic reports, SELinux
troubleshooting, interactive command-line sessions, and more.

###############################################################################

%package bridge
Summary: Cockpit bridge server-side component
Group: System/Base
Requires: glib-networking
Obsoletes: cockpit-pcp < %EVR

%description bridge
The Cockpit bridge component installed server side and runs commands on the
system on behalf of the web based user interface.

###############################################################################

%package doc
Summary: Cockpit deployment and developer guide
Group: Documentation
BuildArch: noarch

%description doc
The Cockpit Deployment and Developer Guide shows sysadmins how to
deploy Cockpit on their machines as well as helps developers who want to
embed or extend Cockpit.

###############################################################################

%package system
Summary: Cockpit admin interface package for configuring and troubleshooting a system
Group: System/Base
BuildArch: noarch
Requires: cockpit-bridge
Requires: cockpit-shell
Requires: cockpit-systemd
Requires: cockpit-users
Requires: cockpit-metrics
Provides: cockpit-tuned = %EVR
Obsoletes: cockpit-tuned < %EVR
%description system
This package contains the Cockpit shell and system configuration interfaces.

###############################################################################

%package metrics
Summary: Cockpit admin interface package for metrics
Group: System/Base
BuildArch: noarch

%description metrics
This package contains the Cockpit metrics configuration interfaces.

###############################################################################

%package shell
Summary: Cockpit admin interface package for configuring shell
Group: System/Base
BuildArch: noarch
Conflicts: cockpit-dashboard
Obsoletes: cockpit-dashboard < 247

%description shell
This package contains the Cockpit shell configuration interfaces.

###############################################################################

%package systemd
Summary: Cockpit admin interface package for configuring systemd
Group: System/Base
BuildArch: noarch
Conflicts: cockpit-realmd
Obsoletes: cockpit-realmd < 247

%description systemd
This package contains the Cockpit systemd configuration interfaces.

###############################################################################

%package tuned
Summary: Cockpit admin interface package for configuring tuned
Group: System/Base
BuildArch: noarch
Requires: tuned

%description tuned
This package contains the Cockpit tuned configuration interfaces.

###############################################################################

%package users
Summary: Cockpit admin interface package for configuring users
Group: System/Base
BuildArch: noarch

# /usr/bin/pwqcheck
Requires: passwdqc-utils

%description users
This package contains the Cockpit users configuration interfaces.

###############################################################################

%package ws
Summary: Cockpit Web Service
Group: System/Base
Requires: glib-networking
Requires: glib2 >= 2.37.4
Requires: sscg
# drop requirement on symlink, which is created at runtime
# by cockpit.socket service
%filter_from_requires /^\/run\/cockpit\/issue$/d

%description ws
The Cockpit Web Service listens on the network, and authenticates users.

If sssd-dbus is installed, you can enable client certificate/smart card
authentication via SSSD/FreeIPA.

###############################################################################

%package kdump
Summary: Cockpit user interface for kernel crash dumping
Group: System/Base
BuildArch: noarch
Requires: cockpit-bridge
Requires: cockpit-shell
Requires: kexec-tools

%description kdump
The Cockpit component for configuring kernel crash dumping.

###############################################################################

%package sosreport
Summary: Cockpit user interface for diagnostic reports
Group: System/Base
Requires: cockpit-bridge
Requires: cockpit-shell
Requires: sos
BuildArch: noarch

%description sosreport
The Cockpit component for creating diagnostic reports with the
sosreport tool.

###############################################################################

%package networkmanager
Summary: Cockpit user interface for networking, using NetworkManager
Group: System/Base
BuildArch: noarch
Requires: cockpit-bridge
Requires: cockpit-shell
Requires: NetworkManager

%description networkmanager
The Cockpit component for managing networking. This package uses
NetworkManager.

###############################################################################

%if_with optional

%package storaged
Summary: Cockpit user interface for storage, using udisks
Group: System/Base
BuildArch: noarch
Requires: cockpit-shell
Requires: udisks2
Requires: udisks2-module-lvm2
# not packaged in ALT
# Requires: udisks2-iscsi >= 2.6
Requires: multipath-tools
Requires: python3(dbus)

%description storaged
The Cockpit component for managing storage.  This package uses udisks.

###############################################################################

%package tests
Summary: Tests for Cockpit
Group: System/Base
Requires: cockpit-bridge
Requires: cockpit-system
Requires: openssh-clients

%description tests
This package contains tests and files used while testing Cockpit.
These files are not required for running Cockpit.

###############################################################################

%if_with packagekit
%package packagekit
Summary: Cockpit user interface for packages
Group: System/Base
BuildArch: noarch
Requires: cockpit-bridge
Requires: packagekit

%description packagekit
The Cockpit components for installing OS updates and Cockpit add-ons,
via PackageKit.
%endif


%endif
###############################################################################

%prep
%setup
%patch -p1

# Automatically generated by sub-merge
tar -xf "$RPM_SOURCE_DIR/node-cache-f7b5d7625b42c301aaaee4fb48df6f60d28f3b2b-sub-merged.tar" -C 'node_modules' --strip-components 1
tar -xf "$RPM_SOURCE_DIR/pixel-test-reference-f2ff51fea8bf5abd7ec0b37b27e36339cb0c1063-sub-merged.tar" -C 'test/reference' --strip-components 1
tar -xf "$RPM_SOURCE_DIR/beipack-4217d8ade60885a18156e86e566b808edad000ee-sub-merged.tar" -C 'vendor/beipack' --strip-components 1
tar -xf "$RPM_SOURCE_DIR/ferny-c8713c4d3ba74a9d8db1ce8e0a15296e6a333257-sub-merged.tar" -C 'vendor/ferny' --strip-components 1
tar -xf "$RPM_SOURCE_DIR/systemd_ctypes-833f5cee8ea5d4c93aecf0ac2bf517cd5b52f5ec-sub-merged.tar" -C 'vendor/systemd_ctypes' --strip-components 1

echo 'm4_define(VERSION_NUMBER, [%version])' > version.m4
echo "__version__ = '%version'" > src/cockpit/_version.py

[ -e package-lock.json ] || touch package-lock.json

# ALT uses /etc/openssh directory, not /etc/ssh one
if grep -qr '/ssh/ssh_known_hosts'; then
    grep -rl '/ssh/ssh_known_hosts' | \
    xargs sed -i 's/\/ssh\/ssh_known_hosts/\/openssh\/ssh_known_hosts/g'
fi

%build
%autoreconf

%configure \
    --disable-silent-rules \
    %{?_without_doc:--disable-doc } \
    --with-cockpit-user=%cockpit_user \
    --with-cockpit-ws-instance-user=%cockpit_wsinstance_user \
    --with-pamdir=%_pam_modules_dir \
    %nil

# run eslint even in production mode to catch any breakages caused by ALT's
# changes and new upstream's code
export ESLINT=1
%make_build all

%check
%make_build VERBOSE=1 check

%install
%makeinstall_std
%make install-tests DESTDIR=%buildroot

## TODO: build python3 package with pyproject
if ! test -d %buildroot%python3_sitelibdir/%name; then
    mkdir -p %buildroot%python3_sitelibdir/
    mv %buildroot%_target_libdir_noarch/python3/site-packages/%{name}* %buildroot%python3_sitelibdir/
fi

mkdir -p %buildroot%_sysconfdir/pam.d
install -p -m 644 %SOURCE1 %buildroot%_sysconfdir/pam.d/cockpit

%if_without packagekit
rm -r %buildroot/%_datadir/cockpit/packagekit
rm -r %buildroot/%_datadir/cockpit/apps
%endif

%find_lang cockpit

# remove selinux stuff
rm -r %buildroot/%_datadir/cockpit/selinux
rm %buildroot%_datadir/metainfo/org.cockpit_project.cockpit_selinux.metainfo.xml

%if_without optional
for pkg in playground storaged; do
    rm -r %buildroot/%_datadir/cockpit/$pkg
done
rm %buildroot%_pam_modules_dir/mock-pam-conv-mod.so
rm %buildroot%_datadir/metainfo/org.cockpit_project.cockpit-storaged.metainfo.xml
%endif

# remove not default brandings, as they have broken symlinks
pushd %buildroot/%_datadir/cockpit/branding
ls -1 | (. /etc/os-release; grep -v "default\|$ID") | xargs rm -vr
popd

# ghost files
mkdir -p %buildroot%_sysconfdir/cockpit
touch %buildroot%_sysconfdir/cockpit/disallowed-users

###############################################################################

%files
%doc AUTHORS COPYING README.md
%_datadir/metainfo/org.cockpit_project.cockpit.appdata.xml
%_iconsdir/hicolor/128x128/apps/cockpit.png
%doc %_man1dir/cockpit.1.*

%files bridge
%doc %_man1dir/cockpit-bridge.1.*
%_sysconfdir/cockpit/machines.d/
%dir %_datadir/cockpit
%_datadir/cockpit/base1/
%_datadir/polkit-1/actions/org.cockpit-project.cockpit-bridge.policy
%_bindir/cockpit-bridge
%_libexecdir/cockpit-askpass
%python3_sitelibdir/%{name}*

%files doc
%_docdir/cockpit

%files system

%files metrics
%_datadir/cockpit/metrics/

%files shell
%_datadir/cockpit/shell/

%files systemd
%_datadir/cockpit/systemd/

%files users
%_datadir/cockpit/users/

%files ws -f cockpit.lang
%doc %_man1dir/cockpit-desktop.1.*
%doc %_man5dir/cockpit.conf.5.*
%doc %_man8dir/cockpit-ws.8.*
%doc %_man8dir/cockpit-tls.8.*
%doc %_man8dir/pam_ssh_add.8.*
%config(noreplace) %_sysconfdir/cockpit/ws-certs.d/
%config(noreplace) %_sysconfdir/pam.d/cockpit

# managed by post script
%ghost %_sysconfdir/issue.d/cockpit.issue
%ghost %_sysconfdir/motd.d/cockpit
%ghost %attr(0644, root, root) %_sysconfdir/cockpit/disallowed-users

%_datadir/cockpit/issue/update-issue
%_datadir/cockpit/issue/inactive.issue
%_unitdir/cockpit.service
%_unitdir/cockpit-issue.service
%_unitdir/cockpit.socket
%_unitdir/cockpit-session-socket-user.service
%_unitdir/cockpit-session.socket
%_unitdir/cockpit-session@.service
%_unitdir/cockpit-wsinstance-http.socket
%_unitdir/cockpit-wsinstance-http.service
%_unitdir/cockpit-wsinstance-https-factory.socket
%_unitdir/cockpit-wsinstance-https-factory@.service
%_unitdir/cockpit-wsinstance-https@.socket
%_unitdir/cockpit-wsinstance-https@.service
%_unitdir/cockpit-wsinstance-socket-user.service
%_unitdir/system-cockpithttps.slice
%_tmpfilesdir/cockpit-ws.conf
%_pam_modules_dir/pam_ssh_add.so
%_pam_modules_dir/pam_cockpit_cert.so
%_libexecdir/cockpit-ws
%_libexecdir/cockpit-wsinstance-factory
%_libexecdir/cockpit-tls
%_libexecdir/cockpit-client
%_libexecdir/cockpit-client.ui
%_libexecdir/cockpit-desktop
%_libexecdir/cockpit-certificate-helper
%_libexecdir/cockpit-certificate-ensure
%attr(4710, root, %cockpit_wsinstance_user) %_libexecdir/cockpit-session
%_datadir/cockpit/static/
%_datadir/cockpit/branding/

%pre ws
%_sbindir/groupadd -r -f %cockpit_group >/dev/null 2>&1 ||:
%_sbindir/useradd -r -g %cockpit_group -d %_sharedstatedir/cockpit -s \
/dev/null -c "User for cockpit web service" %cockpit_user >/dev/null 2>&1 ||:

%_sbindir/groupadd -r -f %cockpit_wsinstance_user >/dev/null 2>&1 ||:
%_sbindir/useradd -r -g %cockpit_wsinstance_user -d %_sharedstatedir/cockpit -s \
/dev/null -c "User for cockpit-ws instances" %cockpit_wsinstance_user >/dev/null 2>&1 ||:

%post ws
if [ "$1" -eq 1 ]; then
    # in ALT nothing provides these dirs yet
    mkdir -p %_sysconfdir/{motd.d,issue.d}

    ln -s ../../run/cockpit/issue %_sysconfdir/motd.d/cockpit
    ln -s ../../run/cockpit/issue %_sysconfdir/issue.d/cockpit.issue

    printf '# List of users which are not allowed to login to Cockpit\nroot\n' > %_sysconfdir/cockpit/disallowed-users
    chmod 644 %_sysconfdir/cockpit/disallowed-users
fi
systemd-tmpfiles --create cockpit-ws.conf >/dev/null 2>&1 ||:
%post_service cockpit.socket
%post_service cockpit.service

%preun ws
%preun_service cockpit.socket
%preun_service cockpit.service

%files kdump
%_datadir/cockpit/kdump/
%_datadir/metainfo/org.cockpit_project.cockpit_kdump.metainfo.xml

%files sosreport
%_datadir/cockpit/sosreport/
%_datadir/metainfo/org.cockpit_project.cockpit_sosreport.metainfo.xml
%_iconsdir/hicolor/64x64/apps/cockpit-sosreport.png

%files networkmanager
%_datadir/cockpit/networkmanager/
%_datadir/metainfo/org.cockpit_project.cockpit_networkmanager.metainfo.xml

%if_with optional

%files storaged
%_datadir/cockpit/storaged/
%_datadir/metainfo/org.cockpit_project.cockpit_storaged.metainfo.xml

%files tests
%_pam_modules_dir/mock-pam-conv-mod.so

%if_with packagekit
%files packagekit
%_datadir/cockpit/apps/
%_datadir/cockpit/packagekit/
%endif

%endif # build optional extension packages

%changelog
