%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: cmark
Version: 0.31.1
%define soversion %version
Release: alt2
Summary: CommonMark parsing and rendering
License: BSD-2-Clause AND MIT
Group: Text tools
URL: https://github.com/commonmark/cmark

Source: %name-%version.tar

Source2: %name.watch

BuildRequires: gcc-c++ cmake ctest

%description
cmark is the C reference implementation of CommonMark,
a rationalized version of Markdown syntax with a spec.

It provides a shared library (libcmark) with functions for parsing
CommonMark documents to an abstract syntax tree (AST), manipulating
the AST, and rendering the document to HTML, groff man, LaTeX,
CommonMark, or an XML representation of the AST.  It also provides a
command-line program (cmark) for parsing and rendering CommonMark
documents.

%package -n libcmark-devel
Summary: Development files for cmark
Group: Development/C++
Provides: cmark-devel = %EVR
Requires: libcmark%soversion = %EVR

%description -n libcmark-devel
This package provides the development files for cmark.

%package -n libcmark%soversion
Summary: CommonMark parsing and rendering library
Group: System/Libraries

%description -n libcmark%soversion
This package provides the cmark library.

%prep
%setup

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%cmake \
	-DCMARK_STATIC=OFF \
	%nil

%cmake_build

%install
%cmake_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%cmake_build --target test

%files
%doc COPYING
%_bindir/*
%_man1dir/*

%files -n libcmark%soversion
%doc COPYING
%_libdir/libcmark.so.%soversion

%files -n libcmark-devel
%doc COPYING README.md
%_includedir/*
%_libdir/libcmark.so
%_libdir/cmake/*
%_pkgconfigdir/libcmark.pc
%_man3dir/*

%changelog
