%define _unpackaged_files_terminate_build 1
%set_verify_elf_method unresolved=strict
%def_disable bootstrap
%if_disabled bootstrap
%def_enable gui
%def_enable docs
%def_disable jsoncpp_bootstrap
%endif
%def_without check
%add_optflags %optflags_shared
%define _cmake__builddir build

Name: cmake
Version: 4.0.4
Release: alt1

Summary: Cross-platform, open-source make system

License: BSD
Group: Development/Tools
Url: https://cmake.org/
VCS: https://gitlab.kitware.com/cmake/cmake.git

# Source-url: https://gitlab.kitware.com/cmake/cmake/-/archive/v%version/cmake-v%version.tar.bz2
Source: %name-%version.tar

Source2: CMakeCache.txt
Patch1: alt-fallback-modules-dir.patch
Patch2: 696d16ae6c5214e314cfc7cb809c2e574bcff651.patch
Patch3: alt-find-mpi.patch

%if_disabled bootstrap
BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
%endif
BuildRequires(pre): rpm-build-xdg
BuildRequires: gcc-c++
BuildRequires: zlib-devel liblzma-devel bzlib-devel 
BuildRequires: libarchive-devel >= 3.3.3
BuildRequires: libcurl-devel
BuildRequires: libexpat-devel libxml2-devel
BuildRequires: libncurses-devel
BuildRequires: jsoncpp-devel >= 1.6.0
BuildRequires: doxygen graphviz zlib-devel
BuildRequires: librhash-devel
BuildRequires: libuv-devel >= 1.28.0
BuildRequires: shared-mime-info rpm-build-vim

%{?_enable_docs:BuildRequires: python3-module-sphinx-sphinx-build-symlink}
%{?_enable_gui:BuildRequires: qt5-base-devel}

%{?!_without_check:%{?!_disable_check:BuildRequires: /proc gcc-fortran java-devel cvs subversion mercurial git-core}}

Obsoletes: cpack < 2.4.5-alt3
Provides: cpack = %version-%release

Requires: %name-modules = %version-%release
# TODO: change cmake to rpm-build-cmake in all specs
Requires: rpm-macros-%name

%add_findreq_skiplist %_datadir/%name/Templates/cygwin-package.sh.in

%filter_from_requires /^gnustep-Backbone.*/d

%description
CMake is used to control the software compilation process using
simple platform and compiler independent configuration files.
CMake generates native makefiles and workspaces that can be
used in the compiler environment of your choice. CMake is quite
sophisticated: it is possible to support complex environments
requiring system configuration, pre-processor generation, code
generation, and template instantiation.


%package modules
Summary: Standard CMake modules
Group: Development/Tools
BuildArch: noarch

%description modules
CMake is used to control the software compilation process using
simple platform and compiler independent configuration files.

This package contains the standard modules from the CMake distribution.


%package -n ccmake
Summary: Curses interface for CMake
Group: Development/Tools
Requires: %name = %version-%release

%description -n ccmake
The "ccmake" executable is the CMake curses interface. Project
configuration settings may be specified interactively through this GUI.
Brief instructions are provided at the bottom of the terminal when the
program is running.


%package -n ctest
Summary: CMake test driver program
Group: Development/Tools
Requires: %name = %version-%release

%description -n ctest
The ctest executable is the CMake test driver program. CMake-generated
build trees created for projects that use the ENABLE_TESTING and
ADD_TEST commands have testing support. This program will run the tests
and report results.


%package gui
Summary: Qt interface for CMake
Group: Development/Tools
Requires: %name = %version-%release

%description gui
The "cmake-gui" executable is the CMake GUI.  Project configuration settings
may be specified interactively.  Brief instructions are provided at the
bottom of the window when the program is running.


%package doc
Summary: CMake docs
Group: Documentation
BuildArch: noarch

%description doc
This package contains CMake docs in DocBook, html and txt formats.


%package -n vim-plugin-%name
Summary: Vim plugins for CMake files
Group: Editors
BuildArch: noarch

%description -n vim-plugin-%name
This package contains updated indent and syntax Vim plugins for CMake files.

%package -n bash-completion-%name
Summary: bash completion for CMake
Group: Shells
BuildArch: noarch

%description -n bash-completion-%name
bash completion for CMake

%prep
%setup
%patch1 -p1
%patch3 -p1
%ifarch %e2k
# workaround for SUNPro compiler also helps EDG
sed -i 's/__SUNPRO_CC/__EDG__/' Source/cmArgumentParserTypes.h
%endif

# use %_optlevel for any compiler
sed -i 's/ -O[23]/ -O%_optlevel/g' Modules/Compiler/*.cmake

# TODO: Source/cm_get_date.c:11:10: fatal error: ../Utilities/cmlibarchive/libarchive/archive_getdate.c:
# cmlibarchive
# remove bundled sources
rm -rv Utilities/{cmbzip2,cmcurl,cmexpat,cmliblzma,cmlibrhash,cmlibuv,cmnghttp2,cmvssetup,cmzlib,cmzstd}/
%if_disabled jsoncpp_bootstrap
rm -rv Utilities/cmjsoncpp/
%endif

%build
%if_enabled bootstrap
mkdir build
pushd build
install -m644 %SOURCE2 ./

CFLAGS="%optflags" CXXFLAGS="%optflags" ../bootstrap \
	--verbose \
	--parallel=%__nprocs \
	--system-libs \
	%{?_enable_gui:--qt-gui} \
	%{?_enable_docs:--sphinx-man --sphinx-html} \
	--prefix=%prefix \
	--datadir=/share/%name \
	--mandir=/share/man \
	--docdir=/share/doc/%name-%version \
	%{?_enable_jsoncpp_bootstrap:--no-system-jsoncpp} \
	%nil

export LD_LIBRARY_PATH=$PWD/Source:$PWD/Source/kwsys/:$PWD/Source/CursesDialog/form%{?_enable_jsoncpp_bootstrap::$PWD/Utilities/cmjsoncpp}
%make_build VERBOSE=1
popd
%else
# without bootstrap
%cmake \
    -DCMAKE_USE_SYSTEM_LIBRARY_CPPDAP=OFF \
    -DCMAKE_USE_SYSTEM_LIBRARIES=ON \
    -DCMAKE_DATA_DIR=share/%name \
    -DCMAKE_DOC_DIR=share/doc/%name-%version \
    -DCMAKE_MAN_DIR=share/man \
    %{?_enable_gui:-DBUILD_QtDialog=ON} \
    %{?_enable_docs:-DSPHINX_HTML=ON -DSPHINX_MAN=ON} \
    %nil
%cmake_build
%endif

%install
pushd build
%if_enabled bootstrap
export LD_LIBRARY_PATH=$PWD/Source:$PWD/Source/kwsys/:$PWD/Source/CursesDialog/form%{?_enable_jsoncpp_bootstrap::$PWD/Utilities/cmjsoncpp}
%else
# FIXME
subst 's|	bin/cmake|	$(CMAKE_COMMAND)|' Makefile
%endif
%makeinstall_std
popd

%if_enabled jsoncpp_bootstrap
cp build/Utilities/cmjsoncpp/libcmjsoncpp.so %buildroot%_libdir/
%endif

%if_with gui
for i in 32 128; do
    install -pD -m644 Source/QtDialog/CMakeSetup$i.png %buildroot%_iconsdir/hicolor/${i}x$i/apps/CMakeSetup.png
done
%endif

mkdir -p %buildroot{%vim_indent_dir,%vim_syntax_dir,%_sysconfdir/bash_completion.d}
install -m644 Auxiliary/vim/indent/%name.vim %buildroot%vim_indent_dir/%name.vim
install -m644 Auxiliary/vim/syntax/%name.vim %buildroot%vim_syntax_dir/%name.vim
rm -rf %buildroot%_datadir/%name/editors/vim

#mv -f %buildroot%_datadir/%name/completions %buildroot%_sysconfdir/bash_completion.d/%name
rm -vf %buildroot/usr/share/emacs/site-lisp/cmake-mode.el
# drop dump requires
rm -rfv %buildroot/%prefix/share/%name/Modules/Platform/AIX/

#install -p  build/Source/kwsys/libcmsys.so  %buildroot%_libdir/libcmsys.so
#install -p  build/Source/kwsys/libcmsys_c.so  %buildroot%_libdir/libcmsys_c.so

mkdir -p %buildroot%_libdir/cmake/

%check
%if_with check
# CTest.UpdateGIT fails, see #20884
unset GIT_DIR
unset GIT_INDEX_FILE
unset GIT_OBJECT_DIRECTORY
unset DISPLAY
pushd build
export LD_LIBRARY_PATH=%buildroot%_libdir
%make_build test ARGS="--output-on-failure -E 'CMake.FileDownload|CTestTestUpload'"
popd
%endif

%files
%_bindir/cmake
%_bindir/cpack
#_libdir/libCMakeLib.so
#_libdir/libCPackLib.so
#_libdir/libcmsys.so
#_libdir/libcmsys_c.so
%dir %_libdir/cmake/
%_datadir/%name/
%_aclocaldir/*
%if_enabled docs
%_man1dir/cmake*.*
%_man1dir/cpack.*
%_man7dir/*
%endif
%dir %_docdir/%name-%version/
%_docdir/%name-%version/LICENSE.rst
%_docdir/%name-%version/CONTRIBUTORS.rst
%_docdir/%name-%version/cmsys/
%exclude %_datadir/%name/Modules/
%if_enabled jsoncpp_bootstrap
%_libdir/libcmjsoncpp.so
%endif

%files modules
%dir %_datadir/%name/
%_datadir/%name/Modules/


%files -n ccmake
%_bindir/ccmake
#_libdir/libcmForm.so
%if_enabled docs
%_man1dir/ccmake.*
%endif


%files -n ctest
%_bindir/ctest
#_libdir/libCTestLib.so
%if_enabled docs
%_man1dir/ctest.*
%endif


%if_enabled gui
%files gui
%_bindir/cmake-gui
%_desktopdir/cmake-gui.desktop
%_xdgmimedir/packages/cmakecache.xml
%_iconsdir/*/*/*/CMakeSetup.png
#_pixmapsdir/*
%endif


%if_enabled docs
%files doc
%dir %_docdir/%name-%version
#_docdir/%name-%version/ccmake.*
#_docdir/%name-%version/cmake*
#_docdir/%name-%version/cpack*
#_docdir/%name-%version/ctest.*
%_docdir/%name-%version/html
%_docdir/%name-%version/cmcppdap/
%endif


%files -n vim-plugin-%name
%vim_indent_dir/*
%vim_syntax_dir/*

%files -n bash-completion-%name
#%_sysconfdir/bash_completion.d/*
%_datadir/bash-completion/completions/*


%changelog
