%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%define git 28f7cd9216

# Decrease debuginfo verbosity to reduce memory consumption during final library linking
%ifarch %ix86 %arm mipsel
%define optflags_debug -g0
#define __nprocs 1
%else
%define optflags_debug -g1
%endif

# LTO-related flags are set by CMake.
# LTO causes LLVM to break badly on %%ix86 see
# https://github.com/llvm/llvm-project/issues/57740
# will enable it conditionally per platform
%global optflags_lto %nil

Name: clspv
Version: 0.1
Release: alt0.8.g%{git}
License: Apache-2.0
Summary: Clspv is a prototype compiler for a subset of OpenCL C to Vulkan compute shaders
Group: Development/Other
Url: https://github.com/google/clspv
Source: %name-%version.tar
Patch0: clspv-spirv-tools-link.patch

BuildRequires(pre): cmake ninja-build
BuildRequires: gcc-c++ zlib-devel libtinfo-devel spirv-headers libspirv-tools-devel python3-base

%description
Clspv is a prototype compiler for a subset of OpenCL C to Vulkan compute
shaders.

It consists of:

 - A set of LLVM Module passes to transform a dialect of LLVM IR into a SPIR-V
   module containing Vulkan compute shaders.
 - A command line compiler tool called 'clspv' to compile a subset of OpenCL C
   into a Vulkan compute shader.

%prep
%setup
%autopatch -p1

%build
export NPROCS="%__nprocs"
if [ "$NPROCS" -gt 64 ]; then
	export NPROCS=64
fi
%cmake -G Ninja \
    -DCMAKE_BUILD_TYPE=Release \
    -DSPIRV_HEADERS_SOURCE_DIR=%_prefix \
    -DSPIRV_TOOLS_SOURCE_DIR=%_prefix \
    -DSPIRV_TOOLS_BINARY_DIR=%_prefix \
    -DCLSPV_BUILD_SPIRV_DIS=OFF \
    -DCLSPV_BUILD_TESTS=OFF \
    -DCMAKE_INSTALL_LIBDIR=%_libdir \
    %nil
%cmake_build

%install
%cmake_install
rm -rf %buildroot%_libdir/*.a

#%%check
#cmake --build "%_cmake__builddir" --target check-spirv

%files
%doc README.md LICENSE CONTRIBUTING.md CONTRIBUTORS AUTHORS docs
%_bindir/*
%_includedir/%name

%changelog
