# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %_var
%define fontpkgname cliquer
%define soname 1

Name: cliquer
Version: 1.23
Release: alt1

Summary: Find cliques in arbitrary weighted graphs

License: GPL-2.0+
Group: Engineering
Url: https://users.aalto.fi/~pat/cliquer.html
VCS: https://github.com/dimpase/autocliquer.git

Source: https://github.com/dimpase/autocliquer/releases/download/v%version/%name-%version.tar.gz
Source1: http://users.aalto.fi/~pat/%name/%{name}_fm.pdf
Source2: http://users.aalto.fi/~pat/%name/%name.pdf
Source3: http://users.aalto.fi/~pat/%name/%{name}_bm.pdf
# Man page formatting by Jerry James, text from the sources
Source4: %name.1
Source44: import.info
Patch: %name-%version-%release.patch

Requires: lib%name%soname = %version-%release

BuildRequires: gcc

%description
The main cliquer package contains a command-line interface to the
cliquer library.  Note that the upstream binary name is "cl", which is
too generic for Fedora.  Therefore, the binary is named "cliquer".

%package common
Group: Engineering
Summary: Common files for %name
BuildArch: noarch

%description common
Cliquer is a set of C routines for finding cliques in an arbitrary
weighted graph.  It uses an exact branch-and-bound algorithm developed
by Patric A.stergA.rd.  It is designed with the aim of being efficient
while still being flexible and easy to use.

%package -n lib%name%soname
Group: System/Libraries
Summary: Library to find cliques in arbitrary weighted graphs
Provides: %name-libs = %version-%release

%description -n lib%name%soname
This package provides main library for %name.

%package -n lib%name-devel
Group: Development/Other
Summary: Development files for cliquer
Provides: %name-devel = %version-%release

%description -n lib%name-devel
This package provides development files for cliquer.

%prep
%setup
%patch -p1

cp -p %SOURCE1 %SOURCE2 %SOURCE3 .

sed -i \
    's/59 Temple Place, Suite 330, Boston, MA  02111-1307/51 Franklin Street, Suite 500, Boston, MA  02110-1335/' \
    LICENSE

%build
%autoreconf
%configure --disable-static --disable-silent-rules

# Get rid of undesirable hardcoded rpaths.
sed -e 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' \
    -e 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' \
    -i libtool

%make_build

%install
%makeinstall_std

# Add missing executable bit
chmod 0755 %buildroot%_libdir/libcliquer.so.%{soname}.*

# We do not want the libtool archive
rm %buildroot%_libdir/*.la

# We do not want to install the examples
rm -fr %buildroot%_datadir/%name

# The name "cl" is very short and ambiguous
mv %buildroot%_bindir/cl %buildroot%_bindir/%name

# Install the man page
mkdir -p %buildroot%_man1dir
cp -p %SOURCE4 %buildroot%_man1dir

%check
LD_LIBRARY_PATH=. make test

%files
%_bindir/%name
%_man1dir/*

%files common
%doc cliquer*.pdf
%doc ChangeLog README
%doc --no-dereference LICENSE

%files -n lib%name%soname
%_libdir/libcliquer.so.%{soname}*

%files -n lib%name-devel
%_includedir/%name/
%_libdir/libcliquer.so
%_pkgconfigdir/lib%name.pc

%changelog
